<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Course extends MY_Controller {

	/**
	 * user admin
	 *
	 * @package		Course
	 *
     * @version		1.0 --
     * @since		Version 1.0 2017
	 */

    public $_list_data = array();

	public function __construct() {

		global $config;
		
		parent::__construct();

        $this->dt_params['dt_headings'] = "course_id,course_category_id,course_title,course_price,course_image,course_is_featured,course_status";
        $this->dt_params['searchable'] = explode(",",$this->dt_params['dt_headings']);

        $this->dt_params['action'] = array(
                                        "hide_add_button" => false ,
                                        "hide" => false ,
                                        "show_delete" => true ,
                                        "show_edit" => true ,
                                        "order_field" => false ,
                                        "show_view" => false ,
                                        "extra" => array(
                                            "add_btn" => '<a title="Mark Grades" href="'.la("course/grade").'/%d/"'.
                                            ' target="_blank"><button class="btn btn-icon-only yellow">'.
                                            '<i class="fa fa-eye"></i></button></a>',
                                            "analytics_btn" => '<a title="See Analytics" href="'.la("course/studentsAnalytics").'/%d/"'.
                                            ' target="_blank"><button class="btn btn-icon-only yellow">'.
                                            '<i class="fa fa-bar-chart"></i></button></a>',
                                            "grade_btn" => '<a title="Grade Book" href="'.la("grade/gradebook").'/%d/"'.
                                            ' target="_blank"><button class="btn btn-icon-only yellow">'.
                                            '<i class="fa fa-book"></i></button></a>',
                                            ) ,
                                      );
        
        $this->_list_data['course_status'] = array( 
                                        STATUS_INACTIVE => "<span class=\"label label-default\">Inactive</span>" , 
                                        3 => "<span class=\"label label-danger\">Pending</span>" ,  
                                        STATUS_ACTIVE =>  "<span class=\"label label-primary\">Active</span>"  
                                    );
        $this->_list_data['course_is_featured'] = array( 
                                        STATUS_INACTIVE => "<span class=\"label label-default\">No</span>" ,  
                                        STATUS_ACTIVE =>  "<span class=\"label label-primary\">Yes</span>"  
                                    );

        $this->_list_data['course_category_id'] = $this->model_category->find_all_list_active(array('where'=>array('category_parent_id'=>1)),"category_name");

        $param = array();
        $param['where']['user_type'] = LECTURER_USER;
        $this->_list_data['course_user_id'] = $this->model_user->get_user_list_active($param);

        // $this->_list_data['course_subject'] = $this->model_subject->find_all_list_active(array(),'subject_name');

        // $this->_list_data['course_type_id'] = $this->model_type->find_all_list_active(array(),'type_name');

        // $this->_list_data['course_name'] = $this->_course_name();

        // For use IN JS Files
        $config['js_config']['paginate'] = $this->dt_params['paginate'];
        
        $_POST = $this->input->post(NULL, true);
    }

    private function _course_name()
    {
        $data = $this->model_course_name->find_all_list_active(array(),'cn_name');
        $var = array();
        if(isset($data) AND array_filled($data)) {
            foreach($data as $value) {
                $var[$value] = $value;
            }
        }
        return $var;
    }

    public function add($id=0 , $data = array())
    {

        $this->register_plugins(array("datatables"));

        if($id)
        {
            
            // $params = array();
            // $params['fields'] = 'cq_id,cq_course_id,cq_subject_id,subject_name,cq_question,cq_correct_answer,cq_gain_point,cq_status,cq_option_1,cq_option_2,cq_option_3,cq_option_4';
            // $params['where']['cq_course_id'] = $id;
            // $this->_list_data['quiz'] = $this->model_course_quiz->get_data($params);

            //debug($this->_list_data['quiz'],1);
        }

        parent::add($id,$data);
    }

	

    public function clipboard($id)
    {
        $data = $this->model_course->find_by_pk($id);
        $var = $data;
        unset($var['course_id']);
        $course_id = $this->model_course->insert_record($var);

        if($course_id > 0) {
            // Subject Script
            $param = array();
            $param['where']['cs_course_id'] = $id;
            $subject = $this->model_course_subject->find_all($param);
            if(isset($subject) AND array_filled($subject)) {
                foreach($subject as $value) {
                    $value['cs_course_id'] = $course_id;
                    $this->model_course_subject->insert_record($value);
                }
            }

            // Question Script
            $param = array();
            $param['where']['cq_course_id'] = $id;
            $quiz_data = $this->model_course_quiz->find_all($param);
            if(isset($quiz_data) AND array_filled($quiz_data)) {
                foreach($quiz_data as $value) {
                    unset($value['cq_id']);
                    $value['cq_course_id'] = $course_id;
                    $this->model_course_quiz->insert_record($value);
                }
            }
        }

        redirect(la('course/?msgtype=success&msg'.urlencode('Copied Tournament')));
    }


    public function grade($id=0, $data=array() )
    {
        $this->register_plugins(array("datatables","flag_sprites"));
        $this->configure_add_page();
        $this->class_name = 'Grade';

        $data['course'] = $this->model_course->find_by_pk($id);
            $param = array();
            $param['where']['assignment_group_course_id'] = $id;
        $data['groups'] = $this->model_assignment_group->find_all($param);

        $data['id'] = $id;
        $this->load_view('grade',$data);
    }

    public function assignment_group(){
 
        if(array_filled($_POST)){
            $data = array();
            $data = $_POST;
            if($data['assignment_group_id'] != null){
            $id = $data['assignment_group_id'];
            $this->model_assignment_group->update_by_pk($id,$data);
            $this->json_param['status'] = true;
            $this->json_param['txt'] = 'Group Updated';
                
            }else{
            $this->model_assignment_group->set_attributes($data);
            $inserted_id = $this->model_assignment_group->save();
            $this->model_assignment_group->update_by_pk($inserted_id,array('assignment_group_status' => $data['assignment_group_status']) );
            $this->json_param['status'] = true;
            $this->json_param['txt'] = 'Group Created';
                
            }
            // print_r($data);
            echo json_encode($this->json_param);
        } 
        
    }
    
    
    public function submitMassAssignmentMarks() {
    $postData = $_POST;
    
    if (isset($postData['student_ids'])) {
  
        $students = $postData['student_ids'];
        
          if (!is_array($students)) {
            $cleaned_students = preg_replace('/[^\d,]/', '', $students);

            $students_array = explode(',', $cleaned_students);
        }

        foreach ($students_array as $key => $user_id) {
  
            $data = [
                'grade_user_id'       => $user_id,
                'grade_course_id'     => $postData['grade_course_id'],
                'grade_marks'     => $postData['grade_marks'],
                'grade_subject_id'    => $postData['grade_subject_id'],
                'grade_related_id'    => $postData['grade_related_id'],
                'grade_assignment_id' => $postData['grade_assignment_id'],
                'grade_total_marks'   => $postData['grade_total_marks'],
                'grade_status'        => $postData['grade_status'],
                'grade_type'         => $postData['grade_type'],
                'grade_feedback'      => 'Missing Submission',
            ];
        
            
            $assignment_id = $data['grade_related_id'];
            $grade_feedback = $data['grade_feedback'];
            
            $where_relation = [
                'grade_user_id'      => $data['grade_user_id'],
                'grade_course_id'    => $data['grade_course_id'],
                'grade_subject_id'   => $data['grade_subject_id'],
                'grade_related_id'   => $data['grade_related_id'],
                'grade_type'         => $postData['grade_type'],
            ];
            
            $this->model_grade->delete_record($where_relation);
            
            unset($data['grade_feedback']);
            
            if (!isset($data['grade_marks'])) {
                $data['grade_marks'] = 0; 
            }
            $data['grade_percentage'] = $data['grade_marks'] / $data['grade_total_marks'] * 100;
            
            $this->model_grade->set_attributes($data);
            $inserted_id = $this->model_grade->save();

            $this->model_grade->update_by_pk($inserted_id, ['grade_status' => $data['grade_status']]);
        }

        $this->json_param['status'] = true;
        $this->json_param['txt'] = 'All student\'s Marks updated';
    }
    else {
        $this->json_param['status'] = false;
        $this->json_param['txt'] = 'No student IDs provided';
    }

    echo json_encode($this->json_param);
}

    public function grade_submit()
    {
        if(array_filled($_POST)) 
        {
            if($this->validate("model_grade"))
            {
                $data = array();
                $data = $_POST;
                //debug($data,1);
                $grade_feedback = $data['grade_feedback'];
                $assignment_submit_id = $data['assignment_submit_id'];
                $assignment_id = $data['grade_related_id'];
                
                $where_relation = array();
                $where_relation[ 'grade_user_id' ] = $data['grade_user_id'];
                $where_relation[ 'grade_course_id' ] = $data['grade_course_id'];
                $where_relation[ 'grade_subject_id' ] = $data['grade_subject_id'];
                $where_relation[ 'grade_related_id' ] = $data['grade_related_id'];
                $where_relation[ 'grade_type' ] = $data['grade_type'];
                $this->model_grade->delete_record($where_relation);
                
                // Unset for other table values
                unset($data['grade_feedback']);
                unset($data['assignment_submit_id']);
                
               
                $data['grade_percentage'] =  $data['grade_marks'] / $data['grade_total_marks'] *100;

                $this->model_grade->set_attributes($data);
                $inserted_id = $this->model_grade->save();
                $this->model_grade->update_by_pk($inserted_id,array('grade_status' => $data['grade_status']) );
                // Feedback save Start
                $save_param = array();
                $save_param['assignment_submit_feedback'] = $grade_feedback;
                $save_param['assignment_submit_points '] = $data['grade_marks'];
                $this->model_assignment_submit->update_by_pk($assignment_submit_id,$save_param);
                // Feedback save End
                
                $this->json_param['status'] = true;
                $this->json_param['txt'] = 'Marks updated';
                // debug($inserted_id , 1);
            }
            else
            {
                $this->json_param['status'] = false;
                $this->json_param['txt'] = validation_errors();
            }
            
            echo json_encode($this->json_param);
        }
    }


    public function ajax_quiz_marks(){
        if(isset($_POST['result_quiz']) AND array_filled($_POST['result_quiz'])){
            $result_quiz = $_POST['result_quiz'];
            $total_marks = array_sum($_POST['total_marks']);
            unset($_POST['result_quiz']);
            unset($_POST['total_marks']);

            $total = 0;
            foreach($result_quiz as $pkid=>$marks){
                $total += $marks;

                $param = array();
                $param['rq_points'] = $marks;
                $param['rq_feedback'] = isset($_POST['feedback'][$pkid]) ? $_POST['feedback'][$pkid] : '';
                $this->model_result_quiz->update_by_pk($pkid,$param);
            }


            $data = array();
            $data = $_POST;

            // Delete previous data
            $where_relation = array();
            $where_relation[ 'grade_user_id' ] = $data['grade_user_id'];
            $where_relation[ 'grade_course_id' ] = $data['grade_course_id'];
            $where_relation[ 'grade_subject_id' ] = $data['grade_subject_id'];
            $where_relation[ 'grade_related_id' ] = $data['grade_related_id'];
            $where_relation[ 'grade_type' ] = $data['grade_type'];
            $this->model_grade->delete_record($where_relation);

            //debug($data,1);
            $data['grade_marks'] = $total;
            $data['grade_total_marks'] = $total_marks;
            $data['grade_percentage'] = $total/$total_marks * 100;
            $data['grade_status'] = $data['grade_status'];

            $this->model_grade->set_attributes($data);
            $inserted_id = $this->model_grade->save();
            $this->model_grade->update_by_pk($inserted_id,array('grade_status' => $data['grade_status']) );
            
            $json_param = array();
            $json_param['status'] = true;
            $json_param['gmarks'] = $total;
            $json_param['txt'] = 'Marks updated';
            echo json_encode($json_param);
        }
    }
    public function quizAnalytics($id=0, $data=array() )
    {
        $this->register_plugins(array("datatables","flag_sprites"));
        $this->configure_add_page();
        
       $sql = "
        SELECT 
            user.user_id,
            user.user_email,
            user.user_firstname,
            user.user_lastname,
            shop_order.order_id,
            shop_item.item_id
        FROM 
            tn_user user
        LEFT JOIN 
            tn_shop_order shop_order ON user.user_id = shop_order.order_user_id
        LEFT JOIN 
            tn_shop_item shop_item ON shop_item.item_order_id = shop_order.order_id 
        WHERE 
            shop_order.order_payment_status = 1 AND shop_item.item_product_id = ?
        GROUP BY 
            user.user_id
        ORDER BY 
            user.user_firstname ASC
    ";

    $query = $this->db->query($sql, array($id));

    $students = $query->result_array(); 
    
    $quiz_sql = "
                SELECT 
                q.quiz_id,
                q.quiz_name,
                cq.cq_id,
                cq.cq_question,
                cq.cq_correct_answer,
                cq.cq_option_1,
                cq.cq_option_2,
                cq.cq_option_3,
                cq.cq_option_4,
                cq.cq_option_5,
                cq.cq_option_6,
                COUNT(CASE WHEN rq.rq_answer = 1 THEN 1 END) AS option_1_count,
                COUNT(CASE WHEN rq.rq_answer = 2 THEN 1 END) AS option_2_count,
                COUNT(CASE WHEN rq.rq_answer = 3 THEN 1 END) AS option_3_count,
                COUNT(CASE WHEN rq.rq_answer = 4 THEN 1 END) AS option_4_count,
                COUNT(CASE WHEN rq.rq_answer = 5 THEN 1 END) AS option_5_count,
                COUNT(CASE WHEN rq.rq_answer = 6 THEN 1 END) AS option_6_count
            FROM 
                tn_quiz q
            JOIN 
                tn_course_quiz cq ON cq.cq_quiz_id = q.quiz_id
            LEFT JOIN 
                tn_result_quiz rq ON rq.rq_question_id = cq.cq_id
            WHERE 
                q.quiz_id = ?
            GROUP BY
                q.quiz_id, cq.cq_id, cq.cq_question
            ORDER BY 
                cq.cq_id;
                ";

//      LEFT JOIN tn_result r ON
//      q.quiz_id = r.r_quiz_id
        
        $quiz_query = $this->db->query($quiz_sql, array($id));

        $quiz = $quiz_query->result_array();
        
        $this->load_view('../analytics/quiz-analytics', [
            'students' => $students,
            'quiz' => $quiz
            ]);
    }
    
    public function studentsAnalytics($id = 0, $data = array()) {
    $this->load->database();
    $this->register_plugins(array("datatables", "flag_sprites"));
    $this->configure_add_page();

    $sql = "
        SELECT 
            user.user_id,
            user.user_email,
            user.user_firstname,
            user.user_lastname,
            shop_order.order_id,
            shop_item.item_id
        FROM 
            tn_user user
        LEFT JOIN 
            tn_shop_order shop_order ON user.user_id = shop_order.order_user_id
        LEFT JOIN 
            tn_shop_item shop_item ON shop_item.item_order_id = shop_order.order_id 
        WHERE 
            shop_order.order_payment_status = 1 AND shop_item.item_product_id = ?
        GROUP BY 
            user.user_id
        ORDER BY 
            user.user_firstname ASC
    ";

    $query = $this->db->query($sql, array($id));

    $students = $query->result_array(); 

    $userIds = [];
    $timeSpent = [];
    $attempts = [];

    // Step 2: Loop through the users and get the number of attempts and time spent
    foreach ($students as $student) {
        $user_id = $student['user_id'];

        $result_sql = "
            SELECT 
                COUNT(*) AS num_attempts,   
                MAX(r_time_spent) AS time_spent     
            FROM 
                tn_result
            WHERE 
                r_user_id = ?
            GROUP BY 
                r_user_id
        ";

        $result_query = $this->db->query($result_sql, array($user_id));

        $result = $result_query->row_array();

        if (!empty($result)) {
            $timeSpent[] = $result['time_spent'];
            $attempts[] = $result['num_attempts'];
        } else {
            $timeSpent[] = 0;
            $attempts[] = 0;
        }

        $userIds[] = $user_id;
    }
        $quiz_sql = "
            SELECT quiz_id,
            count(DISTINCT(r_user_id)) as students_attempted,
            quiz_name
            FROM 
                tn_quiz q
                LEFT JOIN tn_result r ON
                q.quiz_id = r.r_quiz_id
            WHERE 
                q.quiz_course_id = ?
            GROUP BY 
            q.quiz_name;
        ";

        $quiz_query = $this->db->query($quiz_sql, array($id));

        $quiz = $quiz_query->result_array();

        if (!empty($quiz)) {
                foreach ($quiz as $q) {
            $quizzes[] = $q['quiz_name'];
            $studentsAttempted[] = $q['students_attempted'];
                }
        }
        $assignment_sql = "
            SELECT assignment_id,
            count(DISTINCT(assignment_submit_user_id)) as students_attemptedAssignment,
            assignment_title
            FROM 
                tn_assignment a
                LEFT JOIN tn_assignment_submit asub ON
                a.assignment_id = asub.assignment_submit_assignment_id
            WHERE 
                a.assignment_course_id = ?
            GROUP BY 
            a.assignment_title;
        ";

        $ass_query = $this->db->query($assignment_sql, array($id));

        $assignments = $ass_query->result_array();

        if (!empty($assignments)) {
                foreach ($assignments as $assign) {
            $assignmentsData[] = $assign['assignment_title'];
            $studentsAttemptedAssignment[] = $assign['students_attemptedAssignment'];
                }
        }

    $this->load_view('../analytics/student-analytics', [
        'id' => $id,
        'students' => $students,
        'userIds' => $userIds,
        'studentCount' => count($userIds),
        'timeSpent' => $timeSpent,
        'attempts' => $attempts,
        'quizzes' => $quizzes,
        'studentsAttempted' => $studentsAttempted,
        'quizArray' => $quiz,
        'assignmentArray' => $assignments,
        'assignments' => $assignmentsData,
        'studentsAttemptedAssignment' => $studentsAttemptedAssignment,
    ]);
}

    public function getStudentData()
    {
        $user_id = $this->input->get('user_id'); 
        $quiz_id = $this->input->get('quiz_id'); 
        
        if (!$user_id || !$quiz_id) {
            echo json_encode([]);
            return;
        }
        
        $this->db->select('user.user_firstname, user.user_lastname, result.r_time_spent, result.r_user_id');
        $this->db->from('tn_result result');
        $this->db->join('tn_user user', 'user.user_id = result.r_user_id');
        $this->db->where('result.r_user_id', $user_id);
        $this->db->where('result.r_quiz_id', $quiz_id);
        $query = $this->db->get();
    
        $data = $query->result_array();
        
        $timeSpent = [];
        $attempts = [];
        $labels = [];
        
        foreach ($data as $key => $row) {
            $timeSpent[] = $row['r_time_spent'];
            $attempts[] = $key; // Count each row as an attempt
            $labels[] =  'Attempt ' . $key+1;
        }
    
        // Return data as JSON
        echo json_encode([
            'labels' => $labels,
            'timeSpent' => $timeSpent,
            'attempts' => $attempts
        ]);
    }




}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
