<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Coupon extends MY_Controller {

	/**
	 * Coupon Controller
	 *
	 * @package		Self :D
	 * @author      Waqas Ahmed (waqasahmed.it@gmail.com)
	 * @version		2.0 -- Robust , Advanced And More Frustating...
	 * @since		Version 2.0 2015
	 */

    public $_list_data = array();

	public function __construct() {

		global $config;
		
		parent::__construct();
        //$this->dt_params['dt_headings'] = "coupon_id,coupon_code,coupon_rate,coupon_start_date,coupon_expire_date,coupon_status";
        $this->dt_params['dt_headings'] = "coupon_id,coupon_course_id,coupon_code,coupon_start_date,coupon_expire_date,coupon_status";
        $this->dt_params['searchable'] = explode("," , $this->dt_params['dt_headings']);//array("coupon_id","coupon_code","coupon_rate","coupon_audience","coupon_start_date","coupon_expire_date","coupon_status");

        $this->dt_params['action'] = array(
                                        "hide" => false ,
                                        "show_delete" => true ,
                                        "show_edit" => true ,
                                        "order_field" => false ,
                                        "show_view" => false ,
                                        "extra" => array() ,
                                      );
        
        $this->_list_data['coupon_is_first_time'] = array( 
                                        STATUS_INACTIVE => "<span class=\"label label-default\">No</span>" ,  
                                        STATUS_ACTIVE =>  "<span class=\"label label-primary\">YES</span>"  
                                    );

         $this->_list_data['coupon_status'] = array( 
                                        STATUS_INACTIVE => "<span class=\"label label-default\">Inactive</span>" ,  
                                        STATUS_ACTIVE =>  "<span class=\"label label-primary\">Active</span>"  
                                    );


         $this->_list_data['coupon_course_id'] = $this->model_course->find_all_list_active(array(),"course_title");

        // Following are common so, defined in MY_Controller_Admin
		// $this->dt_params['paginate']['class'] = $config['js_config']['ci_class'];
		// $this->dt_params['paginate']['uri'] = "paginate";
		// $this->dt_params['paginate']['update_status_uri'] = "update_status";

		// For use IN JS Files
		$config['js_config']['paginate'] = $this->dt_params['paginate'];
		
		$this->_list_data['coupon_type'] = $this->coupon_type_list();

		// Populating LISTDATA

		$_POST = $this->input->post(NULL, true);
	}
	

	function coupon_type_list()
	{
		return array(
					1=>'Coupon type (%)',
					2=> 'Coupon type ($)'
					);
	}	


	/**
		GENERATE COUPON CODE
	*/
	public function genrate_code()
	{
		//$var = "MKS0091";
		$chars = "0123456789ABCDEFGHIJKLMNOPQRTUVWXYZ9876543210";
		$var = "SS";
		for ($i = 0; $i < 8; $i++) {
		    $var .= $chars[mt_rand(0, strlen($chars)-1)];
		}

		// check coupon code already exist
		$param = array();
		$param['where']['coupon_code'] = $var;
		$data = $this->model_coupon->find_all($param);

		// when coupon code exist than recursive function load
		if(isset($data) && array_filled($data))
		{
			$this->genrate_code();
		}

		echo json_encode($var);
	}



	public function before_index_render(&$data=array())
	{
		$data['page_title'] = 'Scholarship';

		$data['this_class_name'] = $this->this_class_name;

		$this->layout_data['bread_crumbs'] = array(
												array(
													"home/"=>"Home" , 
													'coupon' => 'Scholarship',
												)
											);

		// To access from Child Class
		return true;
	}


	// // BeforeRender Hook to manipulate Overrides... for Add Method
	public function before_add_render(&$data)
	{
		$data['page_title'] = 'Scholarship';

		$data['this_class_name'] = $this->this_class_name;

		$this->layout_data['bread_crumbs'] = array(
												array(
													"home/"=>"Home" , 
													'coupon' => 'Scholarship',
													"coupon/add/" => "Add Scholarship",
												)
											);


		// To access from Child Class
		return true;
	}
}


/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
