<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Category extends MY_Controller {

    /**
     * Achievements page
     *
     * @package		category
     *
     * @version		1.0
     * @since		Version 1.0 2017
     */

    public $_list_data = array();

    public function __construct() {

        global $config;

        parent::__construct();
        $this->dt_params['dt_headings'] = "category_id,category_name,category_status";
        $this->dt_params['searchable'] = explode(",", $this->dt_params['dt_headings']);

        $this->dt_params['action'] = array(
            "hide_add_button" => false ,
            "hide" => false ,
            "show_delete" => true ,
            "show_edit" => true ,
            "order_field" => false ,
            "show_view" => false ,
            "extra" => array() ,
        );

        $this->_list_data['category_status'] = array(
            STATUS_INACTIVE => "<span class=\"label label-default\">Inactive</span>" ,
            STATUS_ACTIVE =>  "<span class=\"label label-primary\">Active</span>"
        );

        // $this->_list_data['category_is_feaured'] = array(
        //     STATUS_INACTIVE => "<span class=\"label label-default\">No</span>" ,
        //     STATUS_ACTIVE =>  "<span class=\"label label-primary\">Yes</span>"
        // );


        // Following are common so, defined in MY_Controller_Admin
        // $this->dt_params['paginate']['class'] = $config['js_config']['ci_class'];
        // $this->dt_params['paginate']['uri'] = "paginate";
        // $this->dt_params['paginate']['update_status_uri'] = "update_status";

        // For use IN JS Files
        $config['js_config']['paginate'] = $this->dt_params['paginate'];

        $this->_list_data['category_parent_id'] = $this->model_category->find_all_list_active(
            array('where_string'=>'category_parent_id = 1')
            ,"category_name");
        

        $_POST = $this->input->post(NULL, true);
    }


    public function add($id=0 , $data = array()) {


        parent::add($id, $data);

    }



    public function before_add_render(&$data)
    {
        $data['page_title'] = 'Category';

        $data['this_class_name'] = $this->this_class_name;

        $this->layout_data['bread_crumbs'] = array(
                                                array(
                                                    "home/"=>"Home" , 
                                                    'category' => 'Category',
                                                    "category/add/" => "Add Category",
                                                )
                                            );

        if(isset($data['form_data']['category']['category_parent_id']) AND ($data['form_data']['category']['category_parent_id'] != 1))
        {
            $data['form_fields']['category']['category_parent_id']['type'] = 'dropdown';
            $data['form_fields']['category']['category_parent_id']['type_filter_dt'] = 'dropdown';

            $data['form_fields']['category']['category_is_feaured']['label'] = 'Is Featured';
            //$data['form_fields']['category']['category_image']['type'] = 'hidden';

        }


        // To access from Child Class
        return true;
    }
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
