<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Assignment_group extends MY_Controller {

	/**
	 *
	 * @package		Quiz
	 *
     * @version		1.0 --
     * @since		Version 1.0 2018
	 */

    public $_list_data = array();
    public $course_id;

	public function __construct() {

		global $config;
		
		parent::__construct();

        $this->dt_params['dt_headings'] = "assignment_group_id,assignment_group_course_id,assignment_group_name,assignment_group_status,assignment_group_createdon";
        $this->dt_params['searchable'] = explode(",", $this->dt_params['dt_headings']);
        
        $this->dt_params['action'] = array(
        								"hide_add_button" => false ,
                                        "hide" => false ,
                                        "show_delete" => true ,
                                        "show_edit" => true ,
                                        "order_field" => false ,
                                        "show_view" => false ,
                                        //"extra" => array() ,
                                        "extra" => array(
                                            "add_btn" => '<a title="Student assignment submission" href="'.la("assignment/get_grade").'/%d/"'.
                                            ' target="_blank"><button class="btn btn-icon-only yellow">'.
                                            '<i class="fa fa-eye"></i></button></a>',
                                            ) ,
                                      );
        $this->_list_data['assignment_group_status'] = array(
                                        STATUS_INACTIVE => "<span class=\"label label-default\">Inactive</span>" ,
                                        STATUS_ACTIVE =>  "<span class=\"label label-primary\">Active</span>"
                                    );
        // Following are common so, defined in MY_Controller_Admin
		// $this->dt_params['paginate']['class'] = $config['js_config']['ci_class'];
		// $this->dt_params['paginate']['uri'] = "paginate";
		// $this->dt_params['paginate']['update_status_uri'] = "update_status";

		// For use IN JS Files

		$config['js_config']['paginate'] = $this->dt_params['paginate'];

        $param = array();
        $this->_list_data['assignment_course_id'] = $this->model_course->find_all_list_active($param,'course_title');

		$_POST = $this->input->post(NULL, true);
	}


    public function get_list()
    {
        $id = $this->input->post("search_val"); 
        $param['fields'] = "assignment_group_id,assignment_group_name";
        $param['where']['assignment_group_course_id'] = $id ;
        $data = $this->_list_data['assignment'] = $this->model_assignment_group->find_all_active($param);
        echo json_encode($data);
    }

    // public function ajax_delete()
    // {
    //     if(isset($_POST) AND array_filled($_POST)) {
    //         $id = intval($_POST['id']);
    //         $where_relation = array();
    //         $where_relation[ 'assignment_group_id' ] = $id;
            
    //         $this->model_assignment_group->delete_record($where_relation);
    //         $json_param['status'] = true;
    //         echo json_encode($json_param);
    //     }
    // }
public function ajax_delete()
{
    if (isset($_POST) && array_filled($_POST)) {
        $id = intval($_POST['id']); 
        $courseid = intval($_POST['courseid']); 

        // Check the total number of assignment groups for the course
        $this->db->where('assignment_group_course_id', $courseid);
        $total_groups = $this->db->count_all_results('assignment_group');
        
        if ($total_groups <= 1) {
            // Return error if only 1 assignment group exists for the course
            $json_param['status'] = false;
            $json_param['message'] = 'Cannot delete the only assignment group for this course.';
        } else {
            // Check if the assignment group is associated with any quizzes or assignments
            $this->db->where('assignment', $id);
            $quiz_count = $this->db->count_all_results('tn_quiz');

            $this->db->where('assignment', $id);
            $assignment_count = $this->db->count_all_results('tn_assignment');

            if ($quiz_count == 0 && $assignment_count == 0) {
                // If no quizzes or assignments are associated, proceed with deletion
                $where_relation = array('assignment_group_id' => $id);
                $this->model_assignment_group->delete_record($where_relation);

                $json_param['status'] = true;
                $json_param['message'] = 'Assignment group deleted successfully';
            } else {

                $json_param['status'] = false;
                $json_param['message'] = 'Cannot delete assignment group because it is associated with quizzes or assignments.';
            }
        }

        echo json_encode($json_param);
    }
}


    
    public function update_group() {
        $data = array();
        $itemId = $this->input->post('id');
        $itemType = $this->input->post('type');
        $newGroupId = $this->input->post('group_id');
        $data['assignment'] = $newGroupId;
        if ($itemType == 'quiz') {
            $this->model_quiz->update_by_pk( $itemId, $data );
        } elseif ($itemType == 'assignment') {
            $this->model_assignment->update_by_pk($itemId, $data);
        }
        $json_param['status'] = true;
        echo json_encode($json_param);
    }


}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
