<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Assignment extends MY_Controller {

	/**
	 *
	 * @package		Quiz
	 *
     * @version		1.0 --
     * @since		Version 1.0 2018
	 */

    public $_list_data = array();
    public $course_id;

	public function __construct() {

		global $config;
		
		parent::__construct();

        $this->dt_params['dt_headings'] = "assignment_id,assignment_course_id,assignment_subject_id,assignment_title,assignment,assignment_startdate,assignment_enddate,assignment_status";
        $this->dt_params['searchable'] = explode(",", $this->dt_params['dt_headings']);
        
        $this->dt_params['action'] = array(
        								"hide_add_button" => false ,
                                        "hide" => false ,
                                        "show_delete" => true ,
                                        "show_edit" => true ,
                                        "order_field" => false ,
                                        "show_view" => false ,
                                        //"extra" => array() ,
                                        "extra" => array(
                                            "add_btn" => '<a title="Student assignment submission" href="'.la("assignment/get_grade").'/%d/"'.
                                            ' target="_blank"><button class="btn btn-icon-only yellow">'.
                                            '<i class="fa fa-eye"></i></button></a>',
                                            ) ,
                                      );
        $this->_list_data['assignment_status'] = array(
                                        STATUS_INACTIVE => "<span class=\"label label-default\">Inactive</span>" ,
                                        STATUS_ACTIVE =>  "<span class=\"label label-primary\">Active</span>"
                                    );
        // Following are common so, defined in MY_Controller_Admin
		// $this->dt_params['paginate']['class'] = $config['js_config']['ci_class'];
		// $this->dt_params['paginate']['uri'] = "paginate";
		// $this->dt_params['paginate']['update_status_uri'] = "update_status";

		// For use IN JS Files

		$config['js_config']['paginate'] = $this->dt_params['paginate'];

        $param = array();
        $this->_list_data['assignment_course_id'] = $this->model_course->find_all_list_active($param,'course_title');

        $param = array();
        $this->_list_data['assignment_subject_id'] = $this->model_course_subject->find_all_list_active($param,'course_subject_name');
        $param = array();
        $this->_list_data['assignment'] = $this->model_assignment_group->find_all_list_active($param,'assignment_group_name');


		$_POST = $this->input->post(NULL, true);
	}


    public function get_list()
    {
        $id = $this->input->post("search_val"); 
        $param['fields'] = "course_subject_id,course_subject_name";
        $param['where']['course_subject_course_id'] = $id ;
        $data = $this->_list_data['assignment_subject_id'] = $this->model_course_subject->find_all_active($param);
        echo json_encode($data);
    }


    public function get_grade($id = 0){
      if($id > 0){
         $data = $this->model_assignment->find_by_pk($id);
         $course_id = isset($data['assignment_course_id']) ? $data['assignment_course_id'] : 0;

         if($course_id> 0){
            redirect(la('course/grade/'.$course_id),true);
         }
      }
    }

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
