<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Announcements extends MY_Controller {

    /**
     * @package     banner
     *
     * @version     1.0 --
     * @since       Version 1.0 2017
     */

    public $_list_data = array();

    public function __construct() {

        global $config;
        
        parent::__construct();
        $this->dt_params['dt_headings'] = "announcements_id,announcements_course_id,announcements_title,announcements_status,announcements_createdon";
        $this->dt_params['searchable'] = explode(",", $this->dt_params['dt_headings']);
        
        $this->dt_params['action'] = array(
                                        "hide_add_button" => false ,
                                        "hide" => false ,
                                        "show_delete" => true ,
                                        "show_edit" => false ,
                                        "order_field" => false ,
                                        "show_view" => false ,
                                        "extra" => array() ,
                                      );
        $this->_list_data['announcements_status'] = array( 
                                        STATUS_INACTIVE => "<span class=\"label label-default\">Inactive</span>" ,
                                        STATUS_ACTIVE =>  "<span class=\"label label-primary\">Active</span>"
                                    );
        // Following are common so, defined in MY_Controller_Admin
        // $this->dt_params['paginate']['class'] = $config['js_config']['ci_class'];
        // $this->dt_params['paginate']['uri'] = "paginate";
        // $this->dt_params['paginate']['update_status_uri'] = "update_status";


        $this->_list_data['announcements_course_id'] = $this->model_course->find_all_list_active(array(),'course_title');

        // For use IN JS Files

        $config['js_config']['paginate'] = $this->dt_params['paginate'];

        $_POST = $this->input->post(NULL, true);
    }


    public function add($id='',$data=array())
	{
		
		$this->form_params['action'] = array(
        	// 'hide_save' => true,
        	// 'hide_save_new' => true,
        	'additional' => 
        		array(
        			'hide_save_text'=>'Sent notification',
        			'hide_save_edit_text'=>'Sent notification & continue',
        			'hide_save_new_text'=>'Sent and add new notification',
        		),

    	);


		if(array_filled($_POST)) {
			$this->prevent_return_on_success = true;

		}

		//parent::add($id,$data);
		$insertId = parent::add($id,$data);
		if($insertId > 0) {
			$this->model_email->annoucement_notifcation($insertId);
			$this->add_redirect_success($insertId);
		}
	}

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
