<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

//Include Admin Wrapper. Break down things abit
include_once(APPPATH . "core/MY_Controller_Account.php");

class Quiz extends MY_Controller_Account {

    /**
     * Achievements page
     *
     * @package     category
     *
     * @version     1.0
     * @since       Version 1.0 2017
     */

    public $_list_data = array();
    private $course_id;
    private $subject_id;

    public function __construct() 
    {
        global $config;
        parent::__construct();

        $this->class_name = 'quiz';//$this->router->fetch_class();
        $this->view_pre = 'account/'.$this->class_name.'/';
        
        $param = array();
        $this->subject_id = $this->input->get('id');
        $this->course_id =  $this->model_course_subject->get_parent_course_id($this->subject_id);

        $this->_list_data['quiz_subject_id'] = $this->model_course_subject->find_all_list_active(array('where'=>array('course_subject_id'=>$this->subject_id)),"course_subject_name");

        $this->_list_data['quiz_course_id'] = $this->model_course->find_all_list_active(array('where'=>array('course_id'=>$this->course_id)),"course_title");
        
        $_POST = $this->input->post(NULL, false);
    }


    // Listing/Data table page
    public function index()
    {
        //$subject_id = $this->input->get('id');
        $token = $this->input->get('token');

        if(md5($this->subject_id)== $token){
            //$this->register_plugins(array("datatables2"));
            $this->register_plugins(array("datatables-front"));
            $this->layout_data['css_files'][] = 'account/components.css';

            $this->view_pre = 'account/account_area_theme/quiz/';
            $class_name = $this->class_name;//$this->router->class;
            $model_name = "model_".$class_name;
            $model_obj = $this->$model_name ;


            $data['user_id'] = $this->userid;
            $data['class'] = $class_name;
            $data['model'] = $model_obj;
            $data['title'] = humanize($this->class_name).' Management';
            $data['add_link'] = l('account/'.$this->class_name.'/add/');
            $data['query'] = '?id='.$this->subject_id.'&token='.md5($this->subject_id);

            // Data Script
            $data['datatable'] = $this->model_quiz->get_data_by_id($this->subject_id);
            $data['heading'] = array("quiz_id","quiz_course_id","quiz_subject_id","quiz_name","quiz_status");

            // $this->_list_data['cq_status'] = array(
            //     STATUS_INACTIVE => "<span class=\"label label-default\">Inactive</span>" ,
            //     STATUS_ACTIVE =>  "<span class=\"label label-primary\">Active</span>"
            // );
            
            $data['subject_id'] = $this->subject_id;
            $data['subject_name'] = $this->model_course_subject->get_name($this->subject_id);
            $data['course_id'] = $this->course_id;

            $this->load_view("datatable" , $data);
        }
        else
        {
            redirect(l('account/course?msgtype=warning&msg='.urlencode('No quiz found in given course')));
        }
    }


    public function add($id='' , $data = array())
    {
        global $config;

        $subject_id = $this->input->get('id');
        $token = $this->input->get('token');

        if(md5($subject_id) == $token){

            $this->layout_data['css_files'][] = 'account/components.css';

            $this->add_script(array( 
                "account/jquery.validate.js" ,
                "account/form-validation-script.js",
                "account/tkd_script.js",
                "account/metronic.js",
                "account/quick-sidebar.js",
                "account/demo.js",
                "account/ui-alert-dialog-api.js",
                "account/layout.js",
            ) , "js" );

            $this->register_plugins("jquery-file-upload","bootstrap-switch",
                "select2",
                "bootbox"
            );

            $this->form_params['action'] = array(
                'hide_save' => true,
                'hide_save_new' => false,
                "save_edit_attr" => "#tab_1" ,
            );

            //$this->register_plugins("bootstrap-fileupload");

            $data['subject_id'] = $this->subject_id;

            $this->view_pre = 'account/account_area_theme/quiz/';
            $insert_mode = FALSE;

            // if(isset($_POST) AND array_filled($_POST)) {
            //     $_POST['quiz']['quiz_subject_id'] = $subject_id;
            // }
            
            $this->prevent_return_on_success = TRUE;
            $insertId = parent::add($id,$data);
            // if($insert_mode) {
            //     $this->model_email->notification_article($insertId);
            // }
            if($insertId > 0)
                $this->add_redirect_success($insertId);

        }
    }

    public function before_add_render(&$data)
    {
        $data['form_fields']['quiz']['quiz_course_id']['type'] = 'hidden';
        $data['form_fields']['quiz']['quiz_subject_id']['type'] = 'hidden';

        if(!isset($data['form_data']['quiz']['quiz_course_id'])){
            $data['form_data']['quiz']['quiz_course_id'] = $this->course_id;
        }
        if(!isset($data['form_data']['quiz']['quiz_subject_id'])){
            $data['form_data']['quiz']['quiz_subject_id'] = $this->subject_id;
        }

        $data['form_data']['quiz']['quiz_status'] = 1;
        $data['form_fields']['quiz']['quiz_status']['type'] = 'hidden';
    }

    public function add_redirect_success($id)
    {
        //$course_id = isset($_POST['quiz']['quiz_course_id']) ? $_POST['quiz']['quiz_course_id'] : 0;
        $this->account_current = "account/".$this->router->fetch_class('') .'/'.$this->router->fetch_method('') . "/";
        switch($_POST['submit'])
        {
            case "SaveNEdit":
                $path = $this->account_current.$id;
            break;
            case "SaveNNew":
                $path = $this->account_current;
            break;
            default:
                $path = "account/".$this->router->fetch_class('') .'/';
            break;
        }
        redirect($path."?id=".$this->subject_id."&token=".md5($this->subject_id)."&msgtype=success&msg=".urlencode('Quiz added.'), 'refresh');
        return $id;
    }


    // not required as there is no subjects dropdown enabled
    //public function get_list()
    // {
    //     $id = $this->input->post("search_val"); 
    //     $param['fields'] = "course_subject_id,course_subject_name";
    //     $param['where']['course_subject_course_id'] = $id ;
    //     $data = $this->_list_data['quiz_subject_id'] = $this->model_course_subject->find_all_active($param);
    //     echo json_encode($data);
    // }


    // // Delete Music
    public function ajax_delete()
    {
        if(isset($_POST) AND array_filled($_POST))
        {
            $id = intval($_POST['id']);
            $this->model_quiz->update_by_pk($id,array('quiz_status' => 2));
            $json_param['status'] = true;
            echo json_encode($json_param);
        }
    }



    public function upload_images(){
    
    $formdata = $_POST['product'];
    $filedata = $_FILES['product'];
    $cmsID = $formdata['product_id'];

    $uploads_dir = 'assets/uploads/product';
    $tmp_name = $filedata["tmp_name"]['product_image'];
    $name = microtime()."_".$filedata["name"]['product_image'];
    move_uploaded_file($tmp_name, "$uploads_dir/$name");

      $Nname = explode(".", $name);
      //debug($name);exit;
      $allowEd = array('mp3','mpeg');
      if(in_array($Nname[2],$allowEd)){
        $insertImage['product_image'] = $name;
        $insertImage['product_image_path'] = 'assets/uploads/product/';
        $where['where']['product_id'] = $cmsID;
          $status = $this->model_product->update_model($where,$insertImage);
          if($status){
            echo json_encode(array('status'=>1,'message'=>'Track updated successfully.'));
          }
          else{
            echo json_encode(array('status'=>0,'message'=>'Please try again.'));  
          }
      }
      else{
        echo json_encode(array('status'=>0,'message'=>'Only mp3 and mpeg format allowed'));  
      }
  }

  //quiz questions working start
   // 05/12/2023
    public function addquiz() {
        $data = $json_param = array();
        $data['index'] = $index = $this->input->post('index');
        $data['quiz_id'] = $quiz_id = $this->input->post('quiz_id');
        $data['question_type'] = $this->model_course_quiz->question_type();

        $data['cq_course_id'] = $this->model_course->find_all_list_active(array(),'course_title');
        $data['quiz_data'] = $this->model_quiz->find_by_pk($quiz_id);
        //debug($data['quiz_data'],1);
        $json_param['html'] = $this->load->view("account/account_area_theme/quiz/_quiz",$data,true);
        $json_param['status'] = true;
        $json_param['nextindex'] = $index+1;
        echo json_encode($json_param);
    }

    public function ajax_save_question() {
        $post = isset($_POST['course_quiz']) ? $_POST['course_quiz'] : array();
        
        if(array_filled($post)){
            foreach($post as $value){
                $save_param = array();
                $save_param['cq_type'] = $value['cq_type'];
                $save_param['cq_quiz_id']  = $cq_quiz_id = $value['cq_quiz_id'];
                $save_param['cq_course_id'] = $value['cq_course_id'];
                $save_param['cq_subject_id'] = $cq_sub_id = $value['cq_subject_id'];
                $save_param['cq_gain_point'] = $value['cq_gain_point'];
                $save_param['cq_question'] = htmlentities($value['cq_question']);

                if(isset($value['cq_option']['1']) AND !empty($value['cq_option']['1']))
                    $save_param['cq_option_1'] = $value['cq_option']['1'];
                if(isset($value['cq_option']['2']) AND !empty($value['cq_option']['2']))
                    $save_param['cq_option_2'] = $value['cq_option']['2'];
                if(isset($value['cq_option']['3']) AND !empty($value['cq_option']['3']))
                    $save_param['cq_option_3'] = $value['cq_option']['3'];
                if(isset($value['cq_option']['4']) AND !empty($value['cq_option']['4']))
                    $save_param['cq_option_4'] = $value['cq_option']['4'];
                if(isset($value['cq_option']['5']) AND !empty($value['cq_option']['5']))
                    $save_param['cq_option_5'] = $value['cq_option']['5'];
                if(isset($value['cq_option']['6']) AND !empty($value['cq_option']['6']))
                    $save_param['cq_option_6'] = $value['cq_option']['6'];

                $save_param['cq_status'] = 1;

                if(isset($value['cq_correct_answer'])){
                    if(array_filled($value['cq_correct_answer']))
                        $save_param['cq_correct_answer'] = implode(",", $value['cq_correct_answer']);
                    else
                        $save_param['cq_correct_answer'] = $value['cq_correct_answer'];
                }
                
                $this->model_course_quiz->set_attributes($save_param);
                $insert_id = $this->model_course_quiz->save();
                
            }
            redirect(l("account/quiz/add/$cq_quiz_id?id=".$cq_sub_id ."&token=".md5($cq_sub_id )."&msgtype=success&msg=".urlencode('Quiz questions added successfully.')."#tab3_primary"), 'refresh');
        }
    }

     public function ajax_delete_question()
    {
      if(intval($this->input->post('id')) > 0) {
        $id = $this->input->post('id');
        $this->model_course_quiz->delete_by_pk($id);
        $json_param = array();
        $json_param['status'] = true;
        echo json_encode($json_param);
      }
    }
    
    
    public function ajax_add_quizes()
    {
        $quiz_id = $this->input->post('quiz_id');
        $question_id = $this->input->post('question_id');
        $table_name = $this->input->post('table_name');
        
        $model_name = 'model_'.$table_name ;
        $model_obj = $this->$model_name ;
        $quiz_data = $model_obj->find_by_pk($question_id);
        
        if(isset($quiz_data) AND array_filled($quiz_data)) {
            unset($quiz_data['cq_id']);
            unset($quiz_data['cq_createdon']);
            
            $data = array();
            $data = $quiz_data;
            $data['cq_quiz_id'] = $quiz_id;
            
            $model_obj->set_attributes($data);
            $model_obj->save();
        }

        $json_param = array();
        $json_param['status'] = true;
        echo json_encode($json_param);
    }

    /**
     * Handles quiz attempt submission using the new question bank structure
     */
    public function submit_attempt() {
        $user_id = $this->userid;
        $quiz_id = $this->input->post('quiz_id'); // Optionally pass quiz_id as hidden input
        $answers = $this->input->post('answers');
        $this->load->model('model_result_quiz');

        if (!empty($answers) && is_array($answers)) {
            foreach ($answers as $qb_id => $answer_data) {
                $save_data = array(
                    'rq_user_id' => $user_id,
                    'rq_quiz_id' => $quiz_id,
                    'rq_question_id' => $qb_id,
                    'rq_answer' => isset($answer_data['answer']) ? $answer_data['answer'] : null,
                    'rq_status' => 1,
                    'rq_createdon' => date('Y-m-d H:i:s'),
                );
                $this->model_result_quiz->insert($save_data);
            }
            $this->session->set_flashdata('success', 'Quiz submitted successfully.');
        } else {
            $this->session->set_flashdata('error', 'No answers submitted.');
        }
        redirect(l('account/quiz'));
    }

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
