<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

//Include Admin Wrapper. Break down things abit
include_once(APPPATH . "core/MY_Controller_Account.php");

class Product extends MY_Controller_Account {

    /**
     * Achievements page
     *
     * @package		category
     *
     * @version		1.0
     * @since		Version 1.0 2017
     */

    public $_list_data = array();

    public function __construct() {

        global $config;

        parent::__construct();

        // if($this->user_type != CONTRIBUTOR_USER){
        //     redirect(l('account/dashboard?msgtype=error&msg='.urlencode('Can\'t access to article Page.')) , 'refresh');
        // }

        $this->class_name = $this->router->fetch_class();
        $this->view_pre = 'account/'.$this->class_name.'/';

        $this->_list_data['product_parent_category_id'] = $this->model_category->find_all_list_active(array('where'=>array('category_parent_id'=>1)),"category_name");
        //$this->_list_data['product_type_id'] = $this->model_product_type->find_all_list_active(array(),"pt_name");
        
        $_POST = $this->input->post(NULL, false);
        
    }


    // Listing/Data table page
    public function index()
    {
        //$this->register_plugins(array("datatables2"));
        $this->register_plugins(array("datatables-front"));

        $this->view_pre = 'account/account_area_theme/default/';
        $class_name = $this->class_name;//$this->router->class;
        $model_name = "model_".$class_name;
        $model_obj = $this->$model_name ;


        $data['user_id'] = $this->userid;
        $data['class'] = $class_name;
        $data['model'] = $model_obj;
        $data['title'] = humanize($this->class_name).' Management';
        $data['add_link'] = l('account/'.$this->class_name.'/add/');

        // Data Script
        $data['datatable'] = $this->model_product->get_data_by_user_id($this->userid);
        $data['heading'] = array('product_id','product_parent_category_id','product_name','product_status');
        $this->_list_data['product_status'] = array(
            STATUS_INACTIVE => "<span class=\"label label-default\">Inactive</span>" ,
            STATUS_ACTIVE =>  "<span class=\"label label-primary\">Active</span>"
        );
        


        $this->load_view("datatable" , $data);

    }


    public function add($id='' , $data = array())
    {
        global $config;

        $this->add_script(array( 
            "account/jquery.validate.js" ,
            "account/form-validation-script.js",
            "account/tkd_script.js",
            "account/metronic.js",
            "account/quick-sidebar.js",
            "account/demo.js",
            "account/ui-alert-dialog-api.js",
            "account/layout.js",
        ) , "js" );

        $this->register_plugins("jquery-file-upload","bootstrap-switch",
            "select2",
            "bootbox"
        );

        $this->register_plugins("bootstrap-fileupload");


        $this->view_pre = 'account/account_area_theme/product/';
        $insert_mode = FALSE;
        if(isset($_POST) AND array_filled($_POST)) {
            $_POST['product']['product_user_id'] = $this->userid;
            if(empty($_POST['product']['product_id'])){
                $insert_mode = TRUE;
                $_POST['product']['product_createdon'] = date("Y-m-d h:m:s");
                $_POST['product']['product_status'] = 0;
            }
        }
        
        $this->prevent_return_on_success = TRUE;
        $insertId = parent::add($id,$data);
        // if($insert_mode) {
        //     $this->model_email->notification_article($insertId);
        // }
        if($insertId > 0)
            $this->add_redirect_success($insertId);
    }

    public function before_add_render(&$data)
    {
        // FOR CHILD META TAG HIDDEN START
        //if($data['form_data']['cms_page']['cms_page_page'] > 1)
        if(1==1)
        {
            $data['form_fields']['product']['product_user_id']['type'] = 'hidden';
            $data['form_fields']['product']['product_user_id']['type'] = 'hidden';
            $data['form_fields']['product']['product_status']['type'] = 'hidden';
        }
        // FOR CHILD META TAG HIDDEN END

    }

    public function add_redirect_success($id)
    {
        $this->account_current = "account/".$this->router->fetch_class('') .'/'.$this->router->fetch_method('') . "/";
        switch($_POST['submit'])
        {

            case "SaveNEdit":
                $path = $this->account_current.$id;
            break;
            case "SaveNNew":
                $path = $this->account_current;
            break;
            default:
                $path = "account/".$this->router->fetch_class('') .'/';
            break;
        }
        redirect($path."?msgtype=success&msg=".urlencode('Product submitted.'), 'refresh');
        return $id;
    }


    public function get_list()
    {
        $id = $this->input->post("search_val"); 
        $param['fields'] = "category_id,category_name";
        $param['where']['category_parent_id'] = $id ;
        $data = $this->_list_data['product_category_id'] = $this->model_category->find_all_active($param);
        echo json_encode($data);
    }


    // Delete Music
    public function ajax_delete()
    {
        if(isset($_POST) AND array_filled($_POST))
        {
            $id = intval($_POST['id']);

            $this->model_product->update_by_pk($id,array('product_status' => 2));

            $json_param['status'] = true;
            echo json_encode($json_param);
        }
    }



    public function upload_images(){
    
    $formdata = $_POST['product'];
    $filedata = $_FILES['product'];
    $cmsID = $formdata['product_id'];

    $uploads_dir = 'assets/uploads/product';
    $tmp_name = $filedata["tmp_name"]['product_image'];
    $name = microtime()."_".$filedata["name"]['product_image'];
    move_uploaded_file($tmp_name, "$uploads_dir/$name");

      $Nname = explode(".", $name);
      //debug($name);exit;
      $allowEd = array('mp3','mpeg');
      if(in_array($Nname[2],$allowEd)){
        $insertImage['product_image'] = $name;
        $insertImage['product_image_path'] = 'assets/uploads/product/';
        $where['where']['product_id'] = $cmsID;
          $status = $this->model_product->update_model($where,$insertImage);
          if($status){
            echo json_encode(array('status'=>1,'message'=>'Track updated successfully.'));
          }
          else{
            echo json_encode(array('status'=>0,'message'=>'Please try again.'));  
          }
      }
      else{
        echo json_encode(array('status'=>0,'message'=>'Only mp3 and mpeg format allowed'));  
      }
  }

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
