<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

//Include Admin Wrapper. Break down things abit
include_once(APPPATH . "core/MY_Controller_Account.php");

class Payment extends MY_Controller_Account {

	/**
	 * Payment Controller. - The deafult controller
	 *
	 * @package		Payment - Default
	 * @author		Dalton Lambert (dalton.developer@gmail.com)
	 * @version		2.0
	 * @since		20 April, 2017
	 */

	//protected $cms_page_id = 1;
	 
	public function __construct()
    {
    	// Call the Model constructor latest_product
        parent::__construct();

        $this->view_pre = "account/theme_1/".$this->router->fetch_class('')."/";

        $this->add_script(array("account.css"));
        $this->layput_data['inner_banner'] = '';//$this->model_inner_banner->find_by_pk_active(7);

        $this->layout_data['trigger_payment_msg'] = FALSE;
    }

	public function connected_account()
	{

		global $config;
		
		// Title
		$this->layout_data['title'] = $data['title'] = "Connect Stripe Account";

		$array['client_id'] = STRIPE_PLATFORM_CLIENTID;
		$array['state'] = "unpaid_".$this->userid;
		$array['redirect_uri'] = l('account/payment/connected-account-stripe-success');
		$array['stripe_user']['email'] = $this->layout_data['user_data']['user_email'];
		$array['stripe_user']['business_type'] = "individual";
		$array['stripe_user']['first_name'] = $this->layout_data['user_data']['user_firstname'];
		$array['stripe_user']['last_name'] = $this->layout_data['user_data']['user_lastname'];

		$data['strip_data'] = http_build_query($array);

		$this->load_view("connected_account",$data);
	}
	

	// https://localhost/waqas/kabre_llc-dev/account/payment/connected-account-stripe-success
	// https://custom-webdevelopment.com/kabre_llc-dev/account/payment/connected-account-stripe-success
	public function connected_account_stripe_success()
	{
		$code = trim($this->input->get('code'));
		$state = trim($this->input->get('state'));
		$user_id = intval(str_replace("unpaid_", "", $state));

		if($user_id == $this->userid)
		{
			//state - asdas_uid
	        $ch = curl_init();
	        $data =array(
	                    'code'=>$code,
	                    'grant_type'=>'authorization_code',
	                    'client_secret'=>STRIPE_SECRET_KEY
	                    );
	        
	        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	        curl_setopt($ch, CURLOPT_URL,'https://connect.stripe.com/oauth/token');
	        curl_setopt($ch,CURLOPT_POSTFIELDS, $data);
	        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

	        $result = curl_exec($ch);  
	        $error = curl_error($ch);
	        curl_close($ch);
	        $decoded = json_decode($result,true);
	        
	        if(isset($decoded['stripe_user_id']))
	        {
	            //update user stripe connected account number
	            $update_data = array(
	                            'user_connected_payment'=>"STRIPE",
	                            'user_connected_id'=>$decoded['stripe_user_id'],
	                            'user_connected_status'=>1,
	                            );
	            $updated = $this->model_user->update_by_pk($this->userid,$update_data);
	            //todo notify user and admin

	            //redirect to unpaid user page for actual payment of package
	            redirect(l('account-area?msgtype=info&msg='.urlencode("You have connected with payment account")));
	        }
	        else
	        {
	        	redirect(l('account-area/connected-account?msgtype=error&msg='.urlencode("Error found in your connected account, please try again")));
	        }
	    }
	    else
        {
            redirect(l('account-area/connected-account?msgtype=error&msg='.urlencode("Error found in your connected account, please try again")));
        }
	}
	




	public function subscriptions()
	{

		global $config;
		
		// Title
		$this->layout_data['title'] = $data['title'] = "Subscriptions ".price(g('db.admin.subscription_fee')).'/year';

		$data['total_order_amount'] = g('db.admin.subscription_fee');
		$data['order_id'] = $this->userid;



		$this->load_view("subscriptions",$data);
	}
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */