<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

//Include Admin Wrapper. Break down things abit
include_once(APPPATH . "core/MY_Controller_Account.php");

class My_courses extends MY_Controller_Account {

	/**
	 * Reset_password Controller. - The deafult controller
	 *
	 * @package		Reset_password - Default
	 * @author		Dalton Lambert (dalton.developer@gmail.com)
	 * @version		2.0
	 * @since		06 March, 2017
	 */

	//protected $cms_page_id = 1;

	public function __construct()
    {
		// Call the Model constructor latest_product
        parent::__construct();

        $this->add_script(array("account.css"));
        $this->layout_data['css_files'][] = 'account/components.css';
        $this->layput_data['inner_banner'] = '';//$this->model_inner_banner->find_by_pk_active(7);
        $this->view_pre .= $this->router->fetch_class()."/";
    }

	public function index()
	{
		global $config;

        // Datatable
        $this->layout_data['css_files'][] = 'account/components.css';

        // Title
		$this->layout_data['title'] = $data['title'] = "My Courses";

		$param = array();
		$param['joins'][] = array(
            "table"=>"shop_item" , 
            "joint"=>"shop_item.item_order_id = shop_order.order_id",
        );
        $param['joins'][] = array(
            "table"=>"course" , 
            "joint"=>"course.course_id = shop_item.item_product_id",
        );
        $param['fields'] = 'order_id,order_payment_status,order_billing_fname,order_billing_lname,order_billing_phone,order_billing_email,order_notes,item_product_id,item_product_name,item_price,course_title,course_short_description,course_image,course_image_path';
        $param['where']['order_user_id'] = $this->userid;
        $param['where']['order_payment_status'] = 1;
		$data['order_data'] = $this->model_shop_order->find_all($param);
		//debug($data['order_data'],1);

		$this->load_view("index",$data);
	}

	public function detail($id)
    {
		$this->register_plugins(array("datatables-front"));

		$genrate_token = md5($id);

		if($genrate_token == $this->input->get('token')){
			$this->_detail($id);
		}
		else{
			redirect(l('account-area/my-courses?msgtype=warning&msg='.urlencode('No course found in given id')));
		}
	}

	private function _detail($id){


        // Title
		$this->layout_data['title'] = $data['title'] = "Course Material";

		$param = array();
		$param['where']['course_subject_course_id'] = $id;
		$data['data'] = $this->model_course_subject->find_all_active($param);
	//	debug(	$data['data']  );
		
		$this->load_view("detail",$data);
	}



    public function quiz($id){
        $this->register_plugins(array("datatables-front"));

        $genrate_token = md5($id);

        if($genrate_token == $this->input->get('token')){
            $this->_quiz($id);
        }
        else{
            redirect(l('account-area/my-courses?msgtype=warning&msg='.urlencode('No course found in given id')));
        }
    }
    
   public function submission($id) {
    $this->register_plugins(array("datatables-front"));

    $generate_token = md5($id);

    if ($generate_token == $this->input->get('token')) {
        // Fetch course details to set the title
        $course = $this->model_course->find_by_pk($id);
        $this->layout_data['title'] = $data['title'] = $course['course_title'] . " Grade per modules";

        $this->layout_data['css_files'][] = 'account/components.css';

        $param = array();
        $param['fields'] = '
            COALESCE(assignment_table.assignment_title, quiz_table.quiz_name) AS title,  /* Fetch assignment title or quiz name */
            grade_id,
            grade_user_id,
            grade_course_id,
            grade_related_id,
            grade_type,
            grade_total_marks,
            grade_marks,
            grade_status,
            course_subject.course_subject_name
        ';
        $param['where']['grade_course_id'] = $id;
        $param['where']['grade_user_id'] = $this->userid;

        // Join course subjects
        $param['joins'][] = array(
            "table" => "course_subject",
            "joint" => "course_subject.course_subject_id = grade_subject_id",
        );

        // Left join for assignments
        $param['joins'][] = array(
            "table" => "assignment AS assignment_table",  // Aliasing assignment table to avoid confusion
            "joint" => "assignment_table.assignment_id = grade_related_id AND grade_type = 'assignment'",
            "type"  => "left",  // Only join for assignment-related grades
        );

        // Left join for quizzes
        $param['joins'][] = array(
            "table" => "quiz AS quiz_table",  // Aliasing quiz table to avoid confusion
            "joint" => "quiz_table.quiz_id = grade_related_id AND grade_type = 'quiz'",
            "type"  => "left",  // Only join for quiz-related grades
        );

        $data['data'] = $this->model_grade->find_all($param);

        $this->load_view("submission", $data);
    } else {
        redirect(l('account-area/my-courses?msgtype=warning&msg=' . urlencode('No course found in given id')));
    }
}

    private function _quiz($id){

        $course = $this->model_course->find_by_pk($id);
        
        // Title
        $this->layout_data['title'] = $data['title'] = $course['course_title'] . " Quizzes";

        $this->layout_data['css_files'][] = 'account/components.css';


        $param = array();
        $param['where']['course_subject_course_id']  = $data['course_id'] = $id;
        $data['data'] = $this->model_course_subject->find_all_active($param);
        
        $this->load_view("quiz",$data);
    }


    public function grade($id){
        $this->register_plugins(array("datatables-front"));
       $this->load->model('Model_grading_settings');
        $genrate_token = md5($id);

        if($genrate_token == $this->input->get('token')){
            //$course = $this->model_course->find_by_pk($id);
        
            // Title
            $this->layout_data['title'] = $data['title'] = $course['course_title'] . " Grade per modules";

            $this->layout_data['css_files'][] = 'account/components.css';

            // $param['where']['grade_course_id']  = $id;
            // $param['where']['grade_user_id']  = $this->userid;

        $this->db->select('u.user_id, CONCAT(u.user_firstname, " ", u.user_lastname) as username, g.grade_related_id, g.grade_marks, g.grade_total_marks, g.grade_percentage, g.grade_status');
        $this->db->from('tn_grade g');
        $this->db->join('user u', 'g.grade_user_id = u.user_id', 'left');
        $this->db->where('g.grade_course_id', $id);
        // $this->db->where('g.grade_status', 1);
        $this->db->where('g.grade_user_id', $this->userid);
        $grades = $this->db->get()->result_array();
        
        // Fetch quizzes, assignments, and assignment groups
        $subQuery = '(SELECT cq_quiz_id, SUM(cq_gain_point) AS total_quiz_points FROM tn_course_quiz GROUP BY cq_quiz_id) AS cq_total';
        

        
            
// Fetch quizzes for the course (with only latest result for each quiz)
$quizSubQuery = $this->db->select('r_quiz_id, MAX(r_createdon) AS latest_result')
    ->from('result')
    ->where('r_user_id', $this->userid)
    ->group_by('r_quiz_id')
    ->get_compiled_select();

$this->db->select('
    ag_q.assignment_group_id,
    ag_q.assignment_group_name,
    cq_total.total_quiz_points AS total_marks,
    ag_q.assignment_group_percentage AS assignment_group_percentage,
    q.quiz_id AS assignment_id,
    q.quiz_name AS title,
    q.quiz_enddate AS due_date,
    r_q.r_createdon AS submitted_date
');
$this->db->from('course c');
$this->db->join('quiz q', 'c.course_id = q.quiz_course_id', 'left');
$this->db->join($subQuery, 'q.quiz_id = cq_total.cq_quiz_id', 'left');
$this->db->join('assignment_group ag_q', 'ag_q.assignment_group_id = q.assignment AND ag_q.assignment_group_course_id = c.course_id', 'left');
// Join with the latest quiz result
$this->db->join("($quizSubQuery) latest_result", 'latest_result.r_quiz_id = q.quiz_id', 'left');
$this->db->join('result r_q', 'r_q.r_quiz_id = latest_result.r_quiz_id AND r_q.r_createdon = latest_result.latest_result', 'left');
$this->db->where('c.course_id', $id);
// $this->db->where('r.r_user_id', $this->id);
$query1 = $this->db->get_compiled_select(); // Compile the query for quizzes

// // Fetch assignments for the course (with only latest submission)
$assignmentSubQuery = $this->db->select('assignment_submit_assignment_id, MAX(assignment_submit_createdon) AS latest_submission')
    ->from('assignment_submit')
    ->where('assignment_submit_user_id', $this->userid)
    ->group_by('assignment_submit_assignment_id')
    ->get_compiled_select();

$this->db->select('
    ag_a.assignment_group_id,
    ag_a.assignment_group_name,
    a.assignment_number AS total_marks,
    ag_a.assignment_group_percentage AS assignment_group_percentage,
    a.assignment_id AS assignment_id,
    a.assignment_title AS title,
    a.assignment_enddate AS due_date,
    a_sub.assignment_submit_createdon AS submitted_date
');
$this->db->from('course c');
$this->db->join('assignment a', 'c.course_id = a.assignment_course_id', 'left');
$this->db->join('assignment_group ag_a', 'ag_a.assignment_group_id = a.assignment AND ag_a.assignment_group_course_id = c.course_id', 'left');
// Join with the latest assignment submission
$this->db->join("($assignmentSubQuery) latest_submission", 'latest_submission.assignment_submit_assignment_id = a.assignment_id', 'left');
$this->db->join('assignment_submit a_sub', 'a_sub.assignment_submit_assignment_id = latest_submission.assignment_submit_assignment_id AND a_sub.assignment_submit_createdon = latest_submission.latest_submission', 'left');
$this->db->where('c.course_id', $id);
// $this->db->where('a_sub.assignment_submit_user_id', $this->id);
$query2 = $this->db->get_compiled_select(); // Compile the query for assignments


$finalQuery = $this->db->query($query1 . " UNION ALL " . $query2);
$assignmentList = $finalQuery->result_array(); // Fetch the final combined result


        $this->db->select('
    COALESCE(ag_q.assignment_group_id, ag_a.assignment_group_id) AS assignment_group_id,
    COALESCE(ag_q.assignment_group_name, ag_a.assignment_group_name) AS assignment_group_name,
    COALESCE(cq_total.total_quiz_points, a.assignment_number) AS total_marks,
    IFNULL(COALESCE(ag_q.assignment_group_percentage, ag_a.assignment_group_percentage), 100) AS assignment_group_percentage,
    COALESCE(q.assignment, a.assignment) AS assignment,
    g.grade_related_id, g.grade_type,
    COALESCE(q.quiz_id, a.assignment_id) AS data_id,
    COALESCE(q.quiz_name, a.assignment_title) AS title,
    COALESCE(q.quiz_enddate, a.assignment_enddate) AS due_date,
    COALESCE(r_q.r_createdon, a_sub.assignment_submit_createdon) AS submitted_date
');
$this->db->from('tn_grade g');
$this->db->join('quiz q', 'g.grade_quiz_id = q.quiz_id AND g.grade_type = "quiz"', 'left');
$this->db->join($subQuery, 'q.quiz_id = cq_total.cq_quiz_id', 'left'); // Subquery join to get total quiz points
$this->db->join('assignment a', 'g.grade_assignment_id = a.assignment_id AND g.grade_type = "assignment"', 'left');
$this->db->join('assignment_group ag_q', 'ag_q.assignment_group_id = q.assignment AND g.grade_type = "quiz" AND ag_q.assignment_group_course_id = '.$id, 'left');
$this->db->join('assignment_group ag_a', 'ag_a.assignment_group_id = a.assignment AND g.grade_type = "assignment" AND ag_a.assignment_group_course_id = '.$id, 'left');

// Subquery to get only the latest submission for the assignment
$this->db->join("($assignmentSubQuery) latest_submission", 'latest_submission.assignment_submit_assignment_id = a.assignment_id', 'left');
$this->db->join('assignment_submit a_sub', 'a_sub.assignment_submit_assignment_id = latest_submission.assignment_submit_assignment_id AND a_sub.assignment_submit_createdon = latest_submission.latest_submission AND a_sub.assignment_submit_user_id = '.$this->userid, 'left');

// Subquery to get only the latest result for the quiz
$this->db->join("($quizSubQuery) latest_result", 'latest_result.r_quiz_id = q.quiz_id', 'left');
$this->db->join('result r_q', 'r_q.r_quiz_id = latest_result.r_quiz_id AND r_q.r_createdon = latest_result.latest_result AND r_q.r_user_id = '.$this->userid, 'left');

$this->db->where('g.grade_course_id', $id);
$this->db->where('g.grade_user_id', $this->userid);

// Group by grade to ensure no duplication of rows
$this->db->group_by(['g.grade_related_id', 'g.grade_type']);
$this->db->order_by('g.grade_related_id');

$quizzes_assignments = $this->db->get()->result_array();

        $this->db->select('
            COALESCE(ag_q.assignment_group_id, ag_a.assignment_group_id) AS assignment_group_id,
            COALESCE(ag_q.assignment_group_name, ag_a.assignment_group_name) AS assignment_group_name,
            COALESCE(cq_total.total_quiz_points, a.assignment_number) AS total_marks,
            IFNULL(COALESCE(ag_q.assignment_group_percentage, ag_a.assignment_group_percentage), 100) AS assignment_group_percentage,
            COALESCE(q.assignment, a.assignment) AS assignment,
            g.grade_related_id, g.grade_type,
            COALESCE(q.quiz_name, a.assignment_title) AS title
        ');
        $this->db->from('tn_grade g');
        $this->db->join('quiz q', 'g.grade_quiz_id = q.quiz_id AND g.grade_type = "quiz"', 'left');
        $this->db->join($subQuery, 'q.quiz_id = cq_total.cq_quiz_id', 'left'); // Subquery join to get total quiz points
        $this->db->join('assignment a', 'g.grade_assignment_id = a.assignment_id AND g.grade_type = "assignment"', 'left');
        $this->db->join('assignment_group ag_q', 'ag_q.assignment_group_id = q.assignment AND g.grade_type = "quiz" AND ag_q.assignment_group_course_id = '.$id, 'left');
        $this->db->join('assignment_group ag_a', 'ag_a.assignment_group_id = a.assignment AND g.grade_type = "assignment" AND ag_a.assignment_group_course_id = '.$id, 'left');
        $this->db->where('g.grade_status', 1);
        $this->db->where('g.grade_course_id', $id);
        $this->db->where('g.grade_user_id', $this->userid);
        $this->db->group_by(['assignment_group_id']);
        $this->db->order_by('g.grade_related_id');
        $assignment_groups = $this->db->get()->result_array();
    
        $this->db->select('
            assignment_group_id,
            assignment_group_name,
            assignment_group_percentage,
        ');
        $this->db->from('tn_assignment_group');
        $this->db->where('assignment_group_course_id', $id);
        $groups = $this->db->get()->result_array();
        
        $studentFinalGrades = [];
     
        foreach ($grades as $g) {
            $student_id = $g['user_id'];
            $totalWeightedScore = 0;
            $totalWeightage = 0;
    
            $studentGroupScores = [];
            $studentGroupTotalMarks = [];
            
            foreach ($quizzes_assignments as $qa) {
                $group_percentage = $qa['assignment_group_percentage'] ? $qa['assignment_group_percentage'] : 100;
            
                if ($g['grade_related_id'] == $qa['grade_related_id']) {
                    $assignment_group_id = $qa['assignment_group_id'];
            
                    if (!isset($studentGroupScores[$assignment_group_id])) {
                        $studentGroupScores[$assignment_group_id] = 0;
                        $studentGroupTotalMarks[$assignment_group_id] = 0;
                    }
            
                    $studentGroupScores[$assignment_group_id] += $g['grade_marks']; 
                    $studentGroupTotalMarks[$assignment_group_id] += $qa['total_marks']; 
                    if ($studentGroupTotalMarks[$assignment_group_id] > 0) {
                        $weightage = $group_percentage / 100; 
                        $weightedScore = ($studentGroupScores[$assignment_group_id] / $studentGroupTotalMarks[$assignment_group_id]) * 100;
                        $finalWeight = $weightedScore * $weightage;
            
                        $totalWeightedScore += $finalWeight;
                    }
                    
                }
            }
    
            $finalGradePercentage = $totalWeightedScore ;
    
            // Store the student's final grade
            $studentFinalGrades[$student_id] = [
                'username' => $g['username'],
                'finalGradePercentage' => $finalGradePercentage
            ];
        }
    
      $data = [
            'quizzes_assignments' => $assignmentList,
            'data' => $quizzes_assignments,
            'datagroups' => $groups,
            'assignment_groups' => $assignment_groups,
            'grades' => $grades,
            'studentFinalGrades' => $studentFinalGrades,
            'course_id' => $id
        ];
        $data['grading_settings'] = $this->Model_grading_settings->get_grading_settings($id);
        if (empty($data['grading_settings'])) {
            // Set default grading settings if not found
            $data['grading_settings'] = [
                'grading_system' => 'pass_fail', // or other default system
                'pass_percentage' => 33,         // Example default pass percentage
                'grade_a_percentage' => NULL,      
                'grade_b_percentage' => NULL,
                'grade_c_percentage' => NULL,
                'grade_d_percentage' => NULL,
                'grade_f_percentage' => NULL,
                'gpa_1_percentage' => NULL,
                'gpa_2_percentage' => NULL,
                'gpa_3_percentage' => NULL,
                'gpa_4_percentage' => NULL,
                'custom_grades' => json_encode([]) // Default empty custom grades
            ];
        }
            // print_r('<pre>');
            // print_r($data);
            // exit;
            $this->load_view("grade",$data);
        }
        else{
            redirect(l('account-area/my-courses?msgtype=warning&msg='.urlencode('No course found in given id')));
        }
    }

    public function assignment($id){
        $this->register_plugins(array("datatables-front"));

        $genrate_token = md5($id);

        if($genrate_token == $this->input->get('token')){
            $course = $this->model_course->find_by_pk($id);
            // Title
            $this->layout_data['title'] = $data['title'] = $course['course_title'] . " Assignment";

            $this->layout_data['css_files'][] = 'account/components.css';


            $param = array();
            $param['where']['course_subject_course_id']  = $data['course_id'] = $id;
            $data['data'] = $this->model_course_subject->find_all($param);
            
            $this->load_view("assignment",$data);
        }
        else{
            redirect(l('account-area/my-courses?msgtype=warning&msg='.urlencode('No course found in given id')));
        }
    }


    public function assignment_detail($id){
        $this->register_plugins(array("datatables-front"));

        $genrate_token = md5($id);

        if($genrate_token == $this->input->get('token')){
            $data['assignment'] = $assignment = $this->model_assignment->find_by_pk($id);
            // Title
            $this->layout_data['title'] = $data['title'] = $course['course_title'] . " Assignment";
            $this->layout_data['css_files'][] = 'account/components.css';

            $data['is_form'] = false;
            //debug($assignment,1);
            $this->load_view("assignment_detail",$data);
        }
        else{
            redirect(l('account-area/my-courses?msgtype=warning&msg='.urlencode('No course found in given id')));
        }
    }

    public function assignment_submit($id){
        $this->register_plugins(array("datatables-front"));

        $genrate_token = md5($id);

        if($genrate_token == $this->input->get('token')){
            $data['assignment'] = $assignment = $this->model_assignment->find_by_pk($id);
            // Title
            $this->layout_data['title'] = $data['title'] = $course['course_title'] . " Assignment";
            $this->layout_data['css_files'][] = 'account/components.css';

            $data['is_form'] = true;
            //debug($assignment,1);
            $this->load_view("assignment_detail",$data);
        }
        else{
            redirect(l('account-area/my-courses?msgtype=warning&msg='.urlencode('No course found in given id')));
        }
    }

    public function assignment_submit_process()
    {
        if(array_filled($_POST)) 
        {
            if($this->validate("model_assignment_submit"))
            {
                $data = $_POST['assignment_submit'];
                $data['assignment_submit_status'] = 1;

                $this->model_assignment_submit->set_attributes($data);
                $inserted_id = $this->model_assignment_submit->save();
                $data['assignment_submit_id'] = $inserted_id; 
                
                $graded = $this->grade_submit_auto($data);
         
                
                
                $this->json_param['status'] = true;
                $this->json_param['txt'] = 'Submitted the assignment and am now awaiting the teacher\'s approval.';
                // debug($inserted_id , 1);
            }
            else
            {
                $this->json_param['status'] = false;
                $this->json_param['txt'] = validation_errors();
            }
            
            echo json_encode($this->json_param);
        }
    }

    public function grade_submit_auto($data)
    {
       
                $assignment_id = $data['assignment_submit_assignment_id'];
                $assignment_submit_user_id = $data['assignment_submit_user_id'];
                $assignment_submit_id = $data['assignment_submit_id'];
                $assignment = $this->model_assignment->find_by_pk($assignment_id);
                
                $where_relation = array();
                $where_relation[ 'grade_user_id' ] = $assignment_submit_user_id;
                $where_relation[ 'grade_course_id' ] = $assignment['assignment_course_id'];
                $where_relation[ 'grade_subject_id' ] = $assignment['assignment_subject_id'];
                $where_relation[ 'grade_related_id' ] = $assignment_id;
                $where_relation[ 'grade_type' ] = "assignment";
                $this->model_grade->delete_record($where_relation);
                
                // Unset for other table values
                // unset($data['grade_feedback']);
                // unset($data['assignment_submit_id']);

                
                $data['grade_user_id'] = $assignment_submit_user_id;
                $data['grade_course_id'] =  $assignment['assignment_course_id'];
                $data['grade_subject_id'] =  $assignment['assignment_subject_id'];
                $data['grade_related_id'] = $assignment_id;
                $data['grade_type'] =  "assignment";
                $data['grade_assignment_id'] = $assignment_id;
                
                   
                $assignment_number = $assignment['assignment_number'];   
                $assignment_startdate = $assignment['assignment_startdate'];   
                $assignment_enddate = $assignment['assignment_enddate'];
                //until date , deduction will be based on how many days passed the end date to until date it's submitted
                $assignment_untildate = $assignment['assignment_untildate']; 
                
                $submitted_date = date('Y-m-d');
                
                $end_date = new DateTime($assignment_enddate);
                $submitted = new DateTime($submitted_date);
                
                $interval = $end_date->diff($submitted);
                $days_late = $interval->days;
                
                $grade_setting = $this->model_grade_setting->find_one(array('where' => array('course_id' => $assignment['assignment_course_id'])));
                if($grade_setting != NULL){
                    
                $late_percentage = $grade_setting['late_percentage']; 
                
                $deduction_percentage = min($days_late * $late_percentage, 100); // max 100% deduction
                $deduction = ($assignment_number * $deduction_percentage) / 100;
                
                $grade_marks = max($assignment_number - $deduction, 0); // Ensure marks don't go below 0
                
                $data['grade_marks'] = $grade_marks;

                $data['grade_percentage'] =  $data['grade_marks'] / $assignment['assignment_number'] *100;

                $this->model_grade->set_attributes($data);
                $inserted_id = $this->model_grade->save();
                $this->model_grade->update_by_pk($inserted_id,array('grade_status' => 0) );
                // Feedback save Start
                $save_param = array();
                $save_param['assignment_submit_feedback'] = $grade_feedback;
                $save_param['assignment_submit_points '] = $data['grade_marks'];
                $this->model_assignment_submit->update_by_pk($assignment_submit_id,$save_param);
                // Feedback save End
                
                $this->json_param['status'] = true;
                $this->json_param['txt'] = 'Marks updated';
                }
                else
                
                {
                $this->json_param['status'] = true;
                $this->json_param['txt'] = 'Submitted for review';
                }
                // debug($inserted_id , 1);
           
    }

	public function test($id){
		//$this->register_plugins(array("datatables-front"));

		$genrate_token = md5($id);

		if($genrate_token == $this->input->get('token')){
			$this->_test($id);
		}
		else{
			redirect(l('account-area/my-courses?msgtype=warning&msg='.urlencode('No test found in given id')));
		}
	}

	private function _test($id){


        // Title
		$this->layout_data['title'] = $data['title'] = "Course test";
		$course_id = $id;
		if($course_id > 0)
        {
            //debug($this->session->userdata['user_input'],1);
            //$this->session->unset_userdata(array('user_input'));
            //debug($this->session->userdata['quiz_data']['question'][$course_id],1);
            if(isset($this->session->userdata['quiz_data']['question'][$course_id]) AND array_filled($this->session->userdata['quiz_data']['question'][$course_id]))
            {
                $data = array();
                    
                $quiz_data = $all_quiz_data = $this->session->userdata['quiz_data']['question'][$course_id];

                $data['size'] = $size = ($course_id == 2) ? 5 : 4;
                $quiz_data = array_chunk($quiz_data, $size);

                $quiz_no = isset($_GET['quiz']) ? intval($_GET['quiz']) : 1;
                $quiz_no_index = ($quiz_no == 0) ? 0 : $quiz_no-1;
            	
                
                $answer_data = isset($this->session->userdata['user_input']['user_answer'][$course_id]) ? $this->session->userdata['user_input']['user_answer'][$course_id] : array();

                $data['quiz_no'] = $quiz_no;
                $data['total_quiz'] = count($all_quiz_data);
                $data['quiz'] = $quiz_data[$quiz_no_index];

                $data['attempted'] = isset($answer_data['attempted']) ? $answer_data['attempted'] : 0;
                $data['correct'] = isset($answer_data['correct']) ? $answer_data['correct'] : 0;
                $data['wrong'] = isset($answer_data['wrong']) ? $answer_data['wrong'] : 0;
                $data['points'] = isset($answer_data['points']) ? $answer_data['points'] : 0;
                

                
                // if($data['attempted'] > 0)
                //     $data['avg'] = ($data['correct']/$data['attempted'])*100;
                // else
                //     $data['avg'] = 0;
                
                // $data['result'] = ($data['avg'] >= PASSING_AVG) ? "PASS" : 'FAIL';

                $data['course_id'] = $course_id;
                //debug($data,1);
                //$this->load_view("index_new",$data);
                //$this->load_view("index",$data);

                $this->load_view("test",$data);
            }
            else {
                //redirect(l('account/my_courses/generate_test/'.$course_id));
                die();
            }
        }
		
		
	}



	//public function generate_test($course_id)
    public function generate_test($course_id=0,$quiz_id)
    {
        if($course_id == 0){
            die("Error found");
        }
        
        $this->session->unset_userdata(array('user_input','quiz_data'));
        $this->session->unset_userdata('user_input');
       
        //$quiz = $this->model_course_quiz->generate_quiz($course_id);
        $quiz = $this->model_course_quiz->generate_quiz($quiz_id);
        
        // Save in Session START
        $sess_array = array();
        $sess_array['course_id'] = $course_id;
        $sess_array['quiz_id'] = $quiz_id;
        $sess_array['question'][$course_id] = $quiz;
        $this->session->set_userdata('quiz_data', $sess_array);
        // Save in Session END

        redirect(l("account-area/my-courses/test/$course_id?quiz=1&token=".md5($course_id)),true);
        die();
    }



    public function check_quiz()
    {
        if(isset($_POST) AND array_filled($_POST))
        {
            $error = array();

           	
            if(isset($_POST['quiz']) AND array_filled($_POST['quiz'])) {
                foreach ($_POST['quiz'] as $key => $value) {
                    if(isset($value['user_answer']) AND !empty($value['user_answer'])){
                        // if(isset($this->session->userdata['user_input']['user_answer'][$value['course_id']]['answer'][$value['quiz_id']])){
                        //     $error[] = "Quiz # " . $value['quiz_no'] . " Already attempted";    
                        // }
                    }
                    // else {
                    //     $error[] = "Quiz # " . $value['quiz_no'] . " Answer is required";
                    // }
                }
            }
            


            if(isset($error) AND array_filled($error)) {
                $this->json_param['status'] = false;
                $this->json_param['txt'] = implode("<br />", $error);
            }
            else {
                foreach ($_POST['quiz'] as $key => $value)
                {
                    $quiz_no = $value['quiz_no'];
                    $timespent = $value['timespent'] ?? 0;
                    unset($value['quiz_no']);
                    $data = $value;
                    $course_id = $data['course_id'];

                    $answer = $this->model_course_quiz->check_answer($data['quiz_id'],$data['user_answer']);
                	
                    $attempted = $this->session->userdata['user_input']['user_answer'][$course_id]['attempted'];
                    $correct = $this->session->userdata['user_input']['user_answer'][$course_id]['correct'];
                    $wrong = $this->session->userdata['user_input']['user_answer'][$course_id]['wrong'];
                    $points = $this->session->userdata['user_input']['user_answer'][$course_id]['points'];

                    $store['attempted'] = $attempted+1;
                    if(isset($answer) AND array_filled($answer))
                    {
                        $data['is_correct_answer'] = 1; // YES
                        $data['points'] = $answer['cq_gain_point'];
                        //$data['points'] = $data['user_answer'];
                        $store['correct'] = $correct+1;
                        $store['wrong'] = $wrong+0;
                        $store['points'] = $points+$data['cq_gain_point'];
                    }
                    else
                    {
                        $data['is_correct_answer'] = 0; // NO
                        $data['points'] = 0;
                        $store['correct'] = $correct+0;
                        $store['wrong'] = $wrong+1;
                        $store['points'] = $points+0;
                    }

                    // Save in Session START
                    $sess_array = $this->session->userdata['user_input'];
                    $sess_array['user_answer'][$course_id]['attempted'] = $store['attempted'];
                    $sess_array['user_answer'][$course_id]['correct'] = $store['correct'];
                    $sess_array['user_answer'][$course_id]['wrong'] = $store['wrong'];
                    $sess_array['user_answer'][$course_id]['points'] = $store['points'];
                    $sess_array['user_answer'][$course_id]['timespent'] = $timespent;
                    $sess_array['user_answer'][$course_id]['answer'][$data['quiz_id']] = $data;

                    $this->session->set_userdata('user_input', $sess_array);
                    // Save in Session END

                }



                //$total_quiz = $this->session->userdata['quiz_data'][$course_id];
                $total_quiz = $this->session->userdata['quiz_data']['question'][$course_id];
                $size = ($course_id == 2) ? 5 : 4;
                $quiz_data = array_chunk($total_quiz, $size);
                $page_no = $this->input->post('page_no');

                if(isset($quiz_data[$page_no]) AND array_filled($quiz_data[$page_no])) {
                    $url = l("account-area/my-courses/test/$course_id?quiz=".($page_no+1)."&token=".md5($course_id));
                }
                else { // If complete course
                    $url = l("account-area/my-courses/result/$course_id?token=".md5($course_id));
                }
                $this->json_param['status'] = true;
                $this->json_param['url'] = $url;
            }

            echo json_encode($this->json_param);
        }
    }



    public function unset_result()
    {
        $this->session->unset_userdata(array('user_input','quiz_data'));
        redirect(l('health_quiz'),1);
        die();
    }


    public function result($id){
		//$this->register_plugins(array("datatables-front"));

		$genrate_token = md5($id);

		if($genrate_token == $this->input->get('token')){
			$this->_result($id);
		}
		else{
			redirect(l('account-area/my-courses?msgtype=warning&msg='.urlencode('No test found in given id')));
		}
	}

    public function _result($course_id)
    {
    	
        global $config;
        $answer_data = isset($this->session->userdata['user_input']['user_answer'][$course_id]) ? $this->session->userdata['user_input']['user_answer'][$course_id] : array();
        if(isset($answer_data['correct']) && array_filled($answer_data))
        {
            $quiz_id = isset($this->session->userdata['quiz_data']['quiz_id']) ? $this->session->userdata['quiz_data']['quiz_id'] : 0;
            $course_id = isset($this->session->userdata['quiz_data']['course_id']) ? $this->session->userdata['quiz_data']['course_id'] : 0;

            $data['avg'] = $this->model_course->get_avg($answer_data['correct'],$answer_data['attempted']);
            $data['result'] = $this->model_course->get_result($data['avg']);
            

            $data['points'] = $answer_data['points'];
            $data['course_id'] = $course_id;
            
            //debug($data,1);
            
            //$data['result_txt'] = $this->model_course_quiz->get_result($answer_data['points'],$course_id);
            
            $data['answer_data'] = $answer_data;
            $this->layout_data['title'] = $data['title'] = 'Result Summary';

            $data['course_data'] = $this->model_course->find_by_pk($data['course_id']);

            if($quiz_id > 0)
                $this->save_result($quiz_id,$course_id);

            //debug($data,1);
            $this->load_view("result",$data);
        }
        else{
            //redirect(l('tests/generate_test/'.$course_id));
            //redirect(l('account/my_courses/generate_test/'.$course_id));
            die();
        }

    }


    // Save Result {{START}}
    public function save_result($quiz_id,$course_id)
    {
        if($this->userid > 0)
        {
            $id = $course_id;
            $user_answer = isset($this->session->userdata['user_input']['user_answer'][$id]) ? $this->session->userdata['user_input']['user_answer'][$id] : array();

            if(array_filled($user_answer))
            {
                
                $timespent_values = [];

                foreach ($user_answer['answer'] as $quiz_key => $quiz_data) {
                    if (isset($quiz_data['timespent']) && is_numeric($quiz_data['timespent'])) {
                        $timespent_values[] = $quiz_data['timespent'];
                    }
                }
            
                if (!empty($timespent_values)) {
                    $max_time_spent = max($timespent_values);
                }
                $total_points = $user_answer['points'];

                $avg = $this->model_course->get_avg($user_answer['correct'],$user_answer['attempted']);
                $result = $this->model_course->get_result($avg);

                $param = array();
                $param['r_user_id'] = $this->userid;
                $param['r_course_id'] = $id;
                $param['r_quiz_id'] = $quiz_id;
                $param['r_start_date'] = $user_answer['start_date'];
                $param['r_end_date'] = $user_answer['end_date'];
                $param['r_total_quiz'] = $user_answer['attempted'];
                $param['r_correct'] = $user_answer['correct'];
                $param['r_wrong'] = $user_answer['wrong'];
                $param['r_avg'] = $avg;
                $param['r_points'] = $total_points;
                $param['r_time_spent'] = $max_time_spent;
                $param['r_is_pass'] = ($result == 'PASS') ? 1 : 0;
                $param['r_status'] = 1;

                $this->model_result->set_attributes($param);
                $result_id = $this->model_result->save();
                if($result_id > 0)
                {
                    if(isset($user_answer['answer']) AND array_filled($user_answer['answer']))
                    {
                        foreach($user_answer['answer'] as $answer)
                        {
                            $param = array();
                            $param['rq_result_id'] = $result_id;
                            $param['rq_course_id'] = $answer['course_id'];
                            $param['rq_subject_id'] = $answer['subject_id'];
                            $param['rq_question_id'] = $answer['quiz_id'];
                            $param['rq_answer'] = is_array($answer['user_answer']) ? implode(",", $answer['user_answer']) : $answer['user_answer'];
                            $param['rq_is_correct_asnwer'] = $answer['is_correct_answer'];
                            $param['rq_points'] = $answer['points'];
                            
                            $this->model_result_quiz->set_attributes($param);
                            $rq_id = $this->model_result_quiz->save();
                        }
                    }
                }
            }
        }
        return true;
    }

	/*
	public function ajax_view_detail()
	{
		$order_id = $this->input->post('order_id');
		$order_data = $this->model_order->find_by_pk($order_id);
		$data['flight_departure_data'] = json_decode($order_data['order_departure_data'],1);
		$data['flight_return_data'] = json_decode($order_data['order_arrival_data'],1);
		$json_param['status'] = true;
		$json_param['html'] = $this->load->view('account/_view_order_detail',$data,true);
		
		echo json_encode($json_param);
	}
	*/
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */