<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

//Include Admin Wrapper. Break down things abit
include_once(APPPATH . "core/MY_Controller_Account.php");

class Course_subject extends MY_Controller_Account {

    /**
     * Achievements page
     *
     * @package		category
     *
     * @version		1.0
     * @since		Version 1.0 2017
     */

    public $_list_data = array();

    public function __construct() {

        global $config;

        parent::__construct();

        $this->layout_data['css_files'][] = 'account/components.css';
        //debug($this->layout_data['css_files'],1);

        //debug($this->layout_data['js_files'],1);
        $this->layout_data['js_files'] = array("font-awesome.js");
        //debug($this->layout_data['js_files'],1);

        // if($this->user_type != CONTRIBUTOR_USER){
        //     redirect(l('account/dashboard?msgtype=error&msg='.urlencode('Can\'t access to article Page.')) , 'refresh');
        // }

        $this->class_name = $this->router->fetch_class();
        $this->view_pre = 'account/'.$this->class_name.'/';

        $param = array();
        $param['where']['course_user_id'] = $this->userid;
        $this->_list_data['course_subject_course_id'] = $this->model_course->find_all_list_active($param,'course_title');
        //debug($this->_list_data,1);
        //$this->_list_data['product_type_id'] = $this->model_product_type->find_all_list_active(array(),"pt_name");

        $this->_list_data['course_subject_status'] = array( 
                                        STATUS_INACTIVE => "<span class=\"btn btn-default\">Inactive</span>" , 
                                        3 => "<span class=\"btn btn-danger\">Pending</span>" ,  
                                        STATUS_ACTIVE =>  "<span class=\"btn btn-primary\">Active</span>"  
                                    );
        
        $_POST = $this->input->post(NULL, false);
        
    }


    // Listing/Data table page
    public function index()
    {
        if($this->input->get('token') == md5($this->input->get('id'))){
            $data['course_id'] = $course_id = $this->input->get('id');
            //$this->register_plugins(array("datatables2"));
            $this->register_plugins(array("datatables-front"));

            $this->view_pre = 'account/account_area_theme/course_subject/';
            $class_name = $this->class_name;//$this->router->class;
            $model_name = "model_".$class_name;
            $model_obj = $this->$model_name ;


            $data['user_id'] = $this->userid;
            $data['class'] = $class_name;
            $data['model'] = $model_obj;
            $data['title'] = humanize($this->class_name).' Management';
            $data['add_link'] = l('account/'.$this->class_name.'/add/?id='.$course_id."&token=".md5($course_id));

            // Data Script
            $data['datatable'] = $this->model_course_subject->get_data_by_course_id($course_id);
            $data['heading'] = array('course_subject_id','course_subject_name','course_subject_status');
            
            // $this->_list_data['course_status'] = array(
            //     STATUS_INACTIVE => "<span class=\"label label-default\">Inactive</span>" ,
            //     STATUS_ACTIVE =>  "<span class=\"label label-primary\">Active</span>"
            // );
            $this->load_view("datatable" , $data);
        }
    }


    public function add($id='' , $data = array())
    {
        if($this->input->get('token') == md5($this->input->get('id'))){
            //$course_id = $this->input->get('id');
            $data['course_id'] = $course_id = $this->input->get('id');

            global $config;

            $this->add_script(array( 
                "account/jquery.validate.js" ,
                "account/form-validation-script.js",
                "account/tkd_script.js",
                "account/metronic.js",
                "account/quick-sidebar.js",
                "account/demo.js",
                "account/ui-alert-dialog-api.js",
                "account/layout.js",
            ) , "js" );

            $this->register_plugins("jquery-file-upload","bootstrap-switch",
                "select2",
                "bootbox"
            );

            $this->register_plugins("bootstrap-fileupload");
            $this->view_pre = 'account/account_area_theme/'.$this->class_name.'/';

            $insert_mode = FALSE;
            if(isset($_POST) AND array_filled($_POST)) {
                $_POST['course_subject']['course_subject_course_id'] = $course_id;
                if(empty($_POST['course_subject']['course_subject_id'])){
                    $insert_mode = TRUE;
                    $_POST['course_subject']['course_subject_createdon'] = date("Y-m-d h:m:s");
                    $_POST['course_subject']['course_subject_status'] = 1; // Pending
                }
            }
            
            $this->prevent_return_on_success = TRUE;
            $insertId = parent::add($id,$data);
            // if($insert_mode) {
            //     $this->model_email->notification_article($insertId);
            // }
            //debug($data,1);
            if($insertId > 0)
                $this->add_redirect_success($insertId,$data);
        }
    }

    public function before_add_render(&$data)
    {
        if(!isset($data['form_data']['course_subject']['course_subject_course_id'])){
            $data['form_data']['course_subject']['course_subject_course_id'] = $data['course_id'];
            $data['form_data']['course_subject']['course_subject_status'] = 1;
        }
        //debug($data,1);
        // FOR CHILD META TAG HIDDEN START
        //if($data['form_data']['cms_page']['cms_page_page'] > 1)
        if(1==1)
        {
            //$data['form_fields']['course_subject']['course_subject_status']['type'] = 'hidden';
        }
        // FOR CHILD META TAG HIDDEN END

    }

    public function add_redirect_success($id,$data=array())
    {

        //debug($data,1);
        $this->account_current = "account/".$this->router->fetch_class('') .'/'.$this->router->fetch_method('') . "/";
        switch($_POST['submit'])
        {
            case "SaveNEdit":
                $path = $this->account_current.$id;
            break;
            case "SaveNNew":
                $path = $this->account_current;
            break;
            default:
                $path = "account/".$this->router->fetch_class('') .'/';
            break;
        }
        redirect($path."?id=".$data['course_id']."&token=".md5($data['course_id'])."&msgtype=success&msg=".urlencode('Subject submitted'), 'refresh');
        return $id;
    }


    public function get_list()
    {
        $id = $this->input->post("search_val"); 
        $param['fields'] = "category_id,category_name";
        $param['where']['category_parent_id'] = $id ;
        $data = $this->_list_data['product_category_id'] = $this->model_category->find_all_active($param);
        echo json_encode($data);
    }


    // Delete Music
    public function ajax_delete()
    {
        if(isset($_POST) AND array_filled($_POST)) {
            $id = intval($_POST['id']);
            $this->model_course->update_by_pk($id,array('course_status' => 2));
            $json_param['status'] = true;
            echo json_encode($json_param);
        }
    }



    public function upload_images(){
    
    $formdata = $_POST['product'];
    $filedata = $_FILES['product'];
    $cmsID = $formdata['product_id'];

    $uploads_dir = 'assets/uploads/product';
    $tmp_name = $filedata["tmp_name"]['product_image'];
    $name = microtime()."_".$filedata["name"]['product_image'];
    move_uploaded_file($tmp_name, "$uploads_dir/$name");

      $Nname = explode(".", $name);
      //debug($name);exit;
      $allowEd = array('mp3','mpeg');
      if(in_array($Nname[2],$allowEd)){
        $insertImage['product_image'] = $name;
        $insertImage['product_image_path'] = 'assets/uploads/product/';
        $where['where']['product_id'] = $cmsID;
          $status = $this->model_product->update_model($where,$insertImage);
          if($status){
            echo json_encode(array('status'=>1,'message'=>'Track updated successfully.'));
          }
          else{
            echo json_encode(array('status'=>0,'message'=>'Please try again.'));  
          }
      }
      else{
        echo json_encode(array('status'=>0,'message'=>'Only mp3 and mpeg format allowed'));  
      }
  }



    public function ajax_add()
    {
        if(array_filled($_POST)) 
        {
            if($this->validate("model_course_subject"))
            {
                $data = $_POST['course_subject'];
                $data['course_subject_status'] = 1;

                $this->model_course_subject->set_attributes($data);
                $inserted_id = $this->model_course_subject->save();
                
                $json_param['status'] = true;
                $json_param['msg'] = 'Subject submitted';
            }
            else
            {
                $json_param['status'] = false;
                $json_param['msg'] = validation_errors();
            }
            
            echo json_encode($json_param);
            exit();
        }
    }
    
    public function show_hide()
    {
      // debug($_POST); 
    $option = $this->input->post("option");
    $record_id = $this->input->post("id");


    $param['pi_visibility']  = $option;
    $this->model_product_image->update_by_pk($record_id,$param);

    $json_param['status'] = 1; 
    $json_param['txt'] = "Saved Successfully"; 
     echo json_encode($json_param);
    
    }

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
