<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

//Include Admin Wrapper. Break down things abit
include_once(APPPATH . "core/MY_Controller_Account.php");

class Course_grade extends MY_Controller_Account {

    /**
     * Achievements page
     *
     * @package		category
     *
     * @version		1.0
     * @since		Version 1.0 2017
     */

    public $_list_data = array();

    public function __construct() {

        global $config;

        parent::__construct();

        // if($this->user_type != CONTRIBUTOR_USER){
        //     redirect(l('account/dashboard?msgtype=error&msg='.urlencode('Can\'t access to article Page.')) , 'refresh');
        // }

        $this->class_name = $this->router->fetch_class();
        $this->view_pre = 'account/'.$this->class_name.'/';
        
        $_POST = $this->input->post(NULL, false);
        
    }


    // Listing/Data table page
    public function index()
    {
        $this->register_plugins(array("datatables2"));
        $this->register_plugins(array("datatables-front" ,"jquery-file-upload","bootstrap-switch",));
        $this->register_plugins("bootstrap-fileupload");

        $this->layout_data['css_files'][] = 'account/components.css';

        $this->add_script(array( 
            "account/jquery.validate.js" ,
            "account/form-validation-script.js",
            "account/tkd_script.js",
            "account/metronic.js",
            "account/quick-sidebar.js",
            "account/demo.js",
            "account/ui-alert-dialog-api.js",
            "account/layout.js",
        ) , "js" );

        $data['course_list'] = $course_list = $this->model_course->get_data_by_user_id($this->userid);

        if (isset($_GET['category_id']) AND intval($_GET['category_id']) > 0) {
            $course_id = $_GET['category_id'];
        }
        else{
            $course_id = isset($course_list[0]['course_id']) ? $course_list[0]['course_id'] : 0;
        }
        $data['course_id'] = $course_id;

        $data['subjects'] = $this->model_course_subject->get_data_by_course_id($course_id);
        //debug($data['subjects'],1);

        $this->load_view("datatable" , $data);
    }


    public function add($id='' , $data = array())
    {
        global $config;

        $this->layout_data['css_files'][] = 'account/components.css';
        
        $this->add_script(array( 
            "account/jquery.validate.js" ,
            "account/form-validation-script.js",
            "account/tkd_script.js",
            "account/metronic.js",
            "account/quick-sidebar.js",
            "account/demo.js",
            "account/ui-alert-dialog-api.js",
            "account/layout.js",
        ) , "js" );

        $this->register_plugins("jquery-file-upload","bootstrap-switch",
            "select2",
            "bootbox"
        );

        $this->register_plugins("bootstrap-fileupload");
        $this->view_pre = 'account/account_area_theme/'.$this->class_name.'/';

        $data['formWrapper']['label_wrap_class'] = 'col-md-3';
        $data['formWrapper']['wrap_class'] = 'col-md-9';

        $this->form_params = array(
            "action" => array(
                "save_edit_attr" => "#tab_1" ,
                "hide_save" => true ,
                "hide_save_new" => true ,
                "hide_cancel" => true ,
            ),
        );
        
        $insert_mode = FALSE;
        if(isset($_POST) AND array_filled($_POST)) {
            $_POST['course']['course_user_id'] = $this->userid;
            if(empty($_POST['course']['course_id'])){
                $insert_mode = TRUE;
                $_POST['course']['course_createdon'] = date("Y-m-d h:m:s");
                $_POST['course']['course_status'] = 3; // Pending
            }
        }
        
        $this->prevent_return_on_success = TRUE;
        $insertId = parent::add($id,$data);
        // if($insert_mode) {
        //     $this->model_email->notification_article($insertId);
        // }
        if($insertId > 0)
            $this->add_redirect_success($insertId);
    }

    public function before_add_render(&$data)
    {
        // FOR CHILD META TAG HIDDEN START
        //if($data['form_data']['cms_page']['cms_page_page'] > 1)
        if(1==1)
        {
            $data['form_fields']['course']['course_user_id']['type'] = 'hidden';
            $data['form_fields']['course']['course_user_id']['type'] = 'hidden';
            $data['form_fields']['course']['course_status']['type'] = 'hidden';
        }
        // FOR CHILD META TAG HIDDEN END

    }

    public function add_redirect_success($id)
    {
        $this->account_current = "account/".$this->router->fetch_class('') .'/'.$this->router->fetch_method('') . "/";
        switch($_POST['submit'])
        {

            case "SaveNEdit":
                $path = $this->account_current.$id;
            break;
            case "SaveNNew":
                $path = $this->account_current;
            break;
            default:
                $path = "account/".$this->router->fetch_class('') .'/';
            break;
        }
        $path = "account/".$this->router->fetch_class('') .'/';
        redirect($path."?msgtype=success&msg=".urlencode('Course submitted, waiting for administrator approval for display in course listing'), 'refresh');
        return $id;
    }


    public function get_list()
    {
        $id = $this->input->post("search_val"); 
        $param['fields'] = "category_id,category_name";
        $param['where']['category_parent_id'] = $id ;
        $data = $this->_list_data['product_category_id'] = $this->model_category->find_all_active($param);
        echo json_encode($data);
    }


    // Delete Music
    public function ajax_delete()
    {
        if(isset($_POST) AND array_filled($_POST)) {
            $id = intval($_POST['id']);
            $this->model_course->update_by_pk($id,array('course_status' => 2));
            $json_param['status'] = true;
            echo json_encode($json_param);
        }
    }



    public function upload_images(){
    
    $formdata = $_POST['product'];
    $filedata = $_FILES['product'];
    $cmsID = $formdata['product_id'];

    $uploads_dir = 'assets/uploads/product';
    $tmp_name = $filedata["tmp_name"]['product_image'];
    $name = microtime()."_".$filedata["name"]['product_image'];
    move_uploaded_file($tmp_name, "$uploads_dir/$name");

      $Nname = explode(".", $name);
      //debug($name);exit;
      $allowEd = array('mp3','mpeg');
      if(in_array($Nname[2],$allowEd)){
        $insertImage['product_image'] = $name;
        $insertImage['product_image_path'] = 'assets/uploads/product/';
        $where['where']['product_id'] = $cmsID;
          $status = $this->model_product->update_model($where,$insertImage);
          if($status){
            echo json_encode(array('status'=>1,'message'=>'Track updated successfully.'));
          }
          else{
            echo json_encode(array('status'=>0,'message'=>'Please try again.'));  
          }
      }
      else{
        echo json_encode(array('status'=>0,'message'=>'Only mp3 and mpeg format allowed'));  
      }
  }

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
