<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Signup extends MY_Controller {

	/**
	 * Signup Controller
	 *
	 * @package		Signup Controller
	 * @author		Dalton Lambert (dalton.developer@gmail.com)
	 * @version		2.0
	 * @since		17 Nov, 2017
	 */

	private $json_param = array();


	public function __construct()
    {
    	// Call the Model constructor latest_product
        parent::__construct();
    }

	public function index()
	{
		global $config;

		

		if(count($_POST) > 0) 
		{
			if($this->validate("model_user"))
			{
			    $param= array();
				$param['where']['user_email'] = $_POST['user']['user_email'];
				$email_data = $this->model_user->find_one($param);

				if(isset($email_data) AND array_filled($email_data)){
					$this->json_param['status'] = false;
					$this->json_param['msg']['title'] = 'Error Occurred';
					$this->json_param['msg']['desc'] = "Email already exist";
					$this->json_param['redirect']['status'] = false;
					echo json_encode($this->json_param);
					die();
				}
				
				// DOB variable
				// $days = sprintf("%02d", $_POST['days']);
				// $month = sprintf("%02d", $_POST['month']);

				// $_POST['user_info']['ui_dob']= $_POST['year'].'-'.$month.'-'.$days;
				
				$user_data = $_POST['user'];
				$user_param = $user_data;
				$user_param['user_server_ip'] = $this->server_public_ip;
				//$user_param['user_points'] = 0;
				$user_param['user_type'] = $user_type = (isset($_POST['user']['user_type']) ? $_POST['user']['user_type'] : CUSTOMER_USER);
				$user_param['user_term_agreed'] = (isset($_POST['user']['user_term_agreed']) ? 1:0);
				$user_param['user_password'] = $this->model_user->_encrypt_password($user_data['user_password']);
				$user_param['user_status'] = ($user_type == CUSTOMER_USER) ? 1 : 3;
				$this->model_user->set_attributes($user_param);
				//$user_id = $this->model_user->save_front();
				$user_id = $this->model_user->save();
				
				if($user_id > 0)
				{
					if(ENVIRONMENT != 'development')
					{
						// sent email to user for info and email verification
						$this->model_email->notification_register($user_id , 'user');

						// sent email to admin for one user added
						$this->model_email->notification_register($user_id , 'admin');
					}

					if($user_type == CUSTOMER_USER)
						$msg = "You have been successfully registered";//, please fill the more information".g('site_title');
					else
						$msg = "You have been successfully registered and application send to admin for approval";
					

					

					if($user_type == CUSTOMER_USER){
						//	SESSION DATA START
						$this->model_user->user_online_status($user_id);
						$this->model_user->auto_login($user_id , 'front');
						//	SESSION DATA END
						if(isset($_POST['url']) AND (!empty($_POST['url']))) {
							//$url = $_POST['url']."?msgtype=success&msg=".$msg;
							$url = $_POST['url'];
						}
						else {
							$url = l('account/dashboard')."?msgtype=success&msg=".$msg;
							//$url = l('account-area');
						}
					}
					else{
						$url = l('login')."?msgtype=success&msg=".$msg;
					}



					$this->json_param['status'] = true;
					$this->json_param['msg']['title'] = 'Success';
					$this->json_param['msg']['desc'] = $msg;

					$this->json_param['redirect']['status'] = true;
					$this->json_param['redirect']['link'] = $url;
				}
				else
				{
					$this->json_param['status'] = false;
					$this->json_param['msg']['title'] = 'Error Occurred';
					$this->json_param['msg']['desc'] = 'Some Error found please try again';
					$this->json_param['redirect']['status'] = false;
				}

			}
			else
			{
				$this->json_param['status'] = false;
				$this->json_param['msg']['title'] = 'Error Occurred';
				$this->json_param['msg']['desc'] = validation_errors();
				$this->json_param['redirect']['status'] = false;
			}
		}

		echo json_encode($this->json_param);


	}

	/**
		Email Authentication Function
	*/
	public function authentication($id)
	{
		$token_number = md5("REG-".$id."GEF");
	    
		if($token_number == $_GET['token'])
		{
			$user_id = $id;

			$update = $this->model_user->update_by_pk($user_id , array('user_email_verified_status'=>1));
			
			if($update > 0)
			{
				//$this->model_user->auto_login($user_id,'front');
				
				$msg = "Your email account has been verified, and now you are good to go.";
				redirect(l('?msgtype=success&msg='.urlencode($msg)));
			}
			else{
				redirect(l('home/notfound'));
			}
		}
		else {
			redirect(l('home/notfound'));
		}
	}


}