<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Cart extends MY_Controller {

	private $isguest;
	private $userdata;
	private $cart_content;
	private $total_item;

	private $total_amount;
	private $shipping_charges;
	private $tax;
	private $discount;
	private $coupon;
	private $total_order_amount;

	function __construct() 
	{
		parent::__construct();
		
		$this->isguest = true;
		$this->userdata = array(); // if isguest true than userdata is empty
		$this->cart_content = $this->cart->contents();
		$this->total_item = $this->cart->total_items();
		$this->total_amount = $this->cart->total();
		$this->shipping_charges = $this->get_shipping_charges();
		$this->tax = $this->_set_tax();
		$this->discount = $this->_set_discount();
		$this->redeem_points_amount = $this->_set_redeem_points_amount();

		$this->total_order_amount = $this->get_order_amount();

		$this->cms_page_id = 3;
        $param = array();
        $param['where']['banner_page_id'] = $this->cms_page_id;
        $this->layout_data['banners'] = $this->model_banner->get_banners($param);

        //debug($this->cart_content,1);
        $this->add_script("cart.css");
		// $this->min_order = $this->layout_data['config_info']['min_order_amount(USD)'][0]['config_value'];
		// $this->free_delivery = $this->layout_data['config_info']['free_delivery_charges(USD)'][0]['config_value'];
		// $this->delivery_charges = $this->layout_data['config_info']['delivery_charges(USD)'][0]['config_value'];
		// $this->tax = $this->layout_data['config_info']['tax(percentage)'][0]['config_value'];
		// $this->store_address = $this->layout_data['config_info']['store_address'][0]['config_value'];
	} 


	private function _set_tax()
	{
		$tax_amount = 0;
		$data = isset($this->session->userdata['tax']) ? $this->session->userdata['tax'] : array();
		if(isset($data['tax_total'])) {
			$tax_amount += $data['tax_total'];
		}

		return $tax_amount;
	}
	
	private function _set_discount()
	{
		$discount = 0;
		$data = isset($this->session->userdata['discount']) ? $this->session->userdata['discount'] : array();
		if(isset($data['coupon']) && array_filled($data['coupon']))
		{
			$coupon_discount = $this->_set_coupon_discount($data['coupon']);

			// save discount amount in session start
			$session_data = array();
			$session_data['discount']['coupon'] = $data['coupon'];
			$session_data['discount']['coupon']['discount_amount'] = $coupon_discount;
			$this->session->set_userdata($session_data);
			// save discount amount in session End

			$discount += $coupon_discount;
			$this->coupon = $data['coupon']['info']['coupon_code'];
		}


		if(isset($this->layout_data['user_data']['user_is_new_user']) AND ($this->layout_data['user_data']['user_is_new_user'] == 1)) {
			$discount = ($this->total_amount*10)/100;
		}


		return $discount;
	}

	private function _set_redeem_points_amount()
	{
		return isset($this->session->userdata['rewards']['avail_amount']) ? $this->session->userdata['rewards']['avail_amount'] : 0;
	}

	private function _set_coupon_discount($data)
	{

		$coupon_discount = $this->model_coupon->calculate_discounted_amount($data['coupon_id'] , $this->total_amount);
		return $coupon_discount;
	}

	private function get_shipping_charges()
	{
		$shipping = 0;
		foreach ($this->cart_content as $key => $value) {
			$shipping += $value['options']['shipping_charges'];
		}
		
		$session_data = array();
		$session_data['shipping_charges']['charges'] = $shipping;
		$session_data['shipping_charges']['info'] = array();
		$session_data['shipping_charges']['info']['type'] = "";
		$this->session->set_userdata($session_data);

		//$charges = ($this->total_amount >= 60) ? 0 : SHIPPING_CHARGES;
		$charges = 0;
		if(isset($this->session->userdata['shipping_charges']['charges']))
			$charges = ($this->session->userdata['shipping_charges']['charges']);

		return $charges;
	}


	private function get_order_amount()
	{
		return ($this->total_amount+$this->shipping_charges+$this->tax)-($this->discount + $this->redeem_points_amount);
	}

	
	// add product in your cart basket
	public function ajax_add_to_cart()
	{
		if(isset($_POST) && array_filled($_POST)){
			if($this->isguest == true || $this->isguest == false)
			{

				$this->cart->destroy();
				$this->session->unset_userdata('discount');

				//debug($_POST,1);
				//if($this->userid > 0)
				if(1 == 1)
				{
					$error_msg = array();
					if($_POST['product_qty'] <= 0)
					{
						$error_msg[] = "You qty is less than zero(0),Please select the qty";
					}

					// if($_POST['product_type'] == 1)
					// {
					// 	if(count($_POST['pack_size_id']) < $_POST['pack_size_count'])
					// 	{
					// 		$error_msg[] = "Please select ".$_POST['pack_size_count']." Product Pack size";
					// 	}
					// }
					// else {
					// 	if(empty($_POST['size']['ps_id']))
					// 	{
					// 		$error_msg[] = "Please select Product size First";
					// 	}
					// }
					if(isset($_POST['color']) AND (empty($_POST['color'])))
					{
						$error_msg[] = "Please select Product color First";
					}

					if(!array_filled($error_msg))
					{
						// $size_data = $this->model_size->find_by_pk($_POST['size']);
						$color_data = $this->model_color->find_by_pk($_POST['color']);

						$data = array(
						   'id'      => intval($_POST['product_id']),
						   'qty'     => intval($_POST['product_qty']),
						   'price'   => $_POST['product_price'],
						   'name'    => htmlentities($_POST['product_name']),
						   'options' => array(
						   		'type' => $_POST['product_type'],
			   					'product_img' => $_POST['product_img'],
			   					//'shipping_charges' => (isset($size_data) AND array_filled($size_data)) ? $size_data : array(),
			   					// 'size_data' => (isset($size_data) AND array_filled($size_data)) ? $size_data : array(),
			   					'color_data' => (isset($color_data) AND array_filled($color_data)) ? $color_data : array(),
			   					//'size_data' => isset($_POST['size']) ? $_POST['size'] : array(),
			   					//'pack_size_data' => isset($_POST['pack_size_id']) ? $_POST['pack_size_id'] : array(),
			   					));

						if($_POST['product_type'] == 1){
							$data['options']['shipping_charges'] = 7;
						}

						$this->cart->product_name_rules = '[:print:]';
						$insert = $this->cart->insert($data);
						
						$json_param['status'] = true;
						$json_param['msg'] = "Add {$_POST['product_name']} in your cart basket";
					}
					else
					{
						$json_param['status'] = false;
						$json_param['msg'] = implode("<br />", $error_msg);
					}
				}
				else{
					$json_param['status'] = false;
					$json_param['msg'] = 'Please login first.';
				}	
			}
			else
			{
				$json_param['status'] = false;
				$json_param['msg'] = 'Error found in cart please try again';	
			}
			echo json_encode($json_param);
		}
		else {
			redirect('404');
		}
	}



	// get cart basket 
	public function ajax_get_cart_basket()
	{

		$data = array();
		
		$data['data'] = $this->cart_content;
		$data['total_items'] = $this->total_item;
		$data['total_amount'] = $this->total_amount;

		//debug($data , 1);
		$json_param['cart_body'] = $this->load->view('cart/_get_basket' , $data , true);
		
		
		$json_param['total_item'] = $this->total_item;
		$json_param['total_amount'] = price($this->total_amount);
		$json_param['shipping_charges'] = price($this->shipping_charges);
		$json_param['order_amount'] = price($this->total_order_amount);
		$json_param['order_discount'] = price($this->discount);
		$json_param['tax'] = price($this->tax);

		// $json_param['status'] = true;
		// $json_param['msg']['title'] = 'Cart Basket';
		// $json_param['msg']['desc'] = 'Cart Basket here';	

		echo json_encode($json_param);
	}

	// Step ONE (Cart Page)
	public function index()
	{
		//$data['inner_banner'] = $this->model_inner_banner->find_by_pk_active(2);

		// Banner
        $data = array();
        $data['banners'] = $this->layout_data['banners'];

		$this->layout_data['title'] = $data['title'] = "Cart";

		$data['data'] = $this->cart_content;
		$data['total_items'] = $this->total_item;
		$data['total_amount'] = $this->total_amount;
		$data['shipping_amount'] = $this->shipping_charges;	
		$data['discount_amount'] = $this->discount;	
		$data['redeem_points_amount'] = $this->redeem_points_amount;	
		$data['tax'] = $this->tax;
		$data['total_order_amount'] = $this->total_order_amount;	

		$discount = $this->session->userdata('discount');
		$data['coupon'] = isset($discount['coupon']) ? $discount['coupon'] : array();	

		$data['postage_charges'] = $this->postage_charges();

		$data['shipping_charges'] = $shipping_charges = $this->session->userdata['shipping_charges'];
		$data['shipping_charges_country_id'] = isset($shipping_charges['info']['type']) ? $shipping_charges['info']['type'] : 1;
		//debug($this->session->userdata['shipping_charges'],1);
		// Rewards Section Start
		// $data['rewards'] = $rewards = $this->model_rewards_config->get_total_rewards($this->userid);
		// $data['rewards_amount'] = $this->model_rewards_config->convert_point_to_amount($rewards);
		// Rewards Section End

		//$this->load_view('stepone',$data);
		//$this->load_view('stepone2',$data);
		$this->load_view('stepone3',$data);
	}

	// Cart Step Two (Checkout page)
	public function step_two()
	{
		// if($this->userid == 0){
		// 	redirect(l('login?msgtype=error&msg='.urlencode('Please login first').'&url='.urlencode(l('checkout'))) , true);
		// }
		// Banner
        $data = array();
        $data['banners'] = $this->layout_data['banners'];

		$this->layout_data['title'] = $data['title'] = "Checkout";


		//if(isset($this->session->userdata['shipping_charges']) && array_filled($this->session->userdata['shipping_charges']))
		if(1 == 1)
		{
			if($this->total_amount > 0)
			{
				if(array_filled($this->cart->contents())){
					foreach($this->cart->contents() as $key=>$value){
						$course_id = $value['id'];
					}
				}

				$data['course_id'] = isset($course_id) ? $course_id : 0;
				$data['data'] = $this->cart_content;
				$data['total_items'] = $this->total_item;
				$data['total_amount'] = $this->total_amount;
				$data['shipping_amount'] = $this->shipping_charges;		
				$data['discount_amount'] = $this->discount;		
				$data['tax'] = $this->tax;
				$data['redeem_points_amount'] = $this->redeem_points_amount;	
				$data['total_order_amount'] = $this->total_order_amount;	

				$data['country_list'] = $this->model_country->get_country_checkout();
				//$data['state_list'] = $this->model_country->get_country_state();

				
				$data['member_data'] = $this->model_user->find_by_pk($this->userid);
				
				$data['shipping_charges'] = $shipping_charges = $this->session->userdata['shipping_charges'];
				$data['shipping_charges_country_id'] = isset($shipping_charges['info']['type']) ? $shipping_charges['info']['type'] : 1;

				//debug($data , 1);
				//$this->load_view('steptwo',$data);
				//$this->load_view('steptwo2',$data);
				$this->load_view('steptwo3',$data);
			}
			else {
				redirect(l('cart?msgtype=error&msg='.urlencode('Your cart is empty')) , true);
			}
		}
		else {
			redirect(l('cart?msgtype=error&msg='.urlencode('please select Shipping Method')) , true);
		}
	}

	public function payment()
	{
		if($this->userid > 0) {
			if(isset($_GET['oid']) AND intval($_GET['oid']) > 0)
			{
		        $data = array();
				$data['order_id'] = $order_id = $this->input->get('oid');

				// Banner
		        $data['banners'] = $this->layout_data['banners'];

				$this->layout_data['title'] = $data['title'] = "Payment";

				//$data['inner_banner'] = $this->model_inner_banner->find_by_pk_active(2);
				//$data['title'] = "Payment";

				$order_data = $this->model_shop_order->get_order_by_pk($order_id);
				if(isset($order_data) AND array_filled($order_data))
				{
					$items = '';
					foreach ($order_data['items'] as $value) {
						$items .= $value['item_product_name']." ,";
					}
					$items = rtrim($items,",");

					$data['data'] = $order_data;
					$data['total_items'] = count($order_data['items']);
					$data['total_amount'] = $order_data['price'];
					$data['shipping_amount'] = $order_data['order_shipping_amount'];
					$data['discount_amount'] = $order_data['order_discount_amount'];
					$data['tax'] = $this->tax;
					$data['redeem_points_amount'] = $this->redeem_points_amount;
					$total_order_amount = $data['total_order_amount'] = $this->total_order_amount;
					

					if($total_order_amount == 0){
						$param = array();
		                $param['order_payment_status'] = 1;
		                $param['order_paypal_date'] = date("Y-m-d");
		                $param['order_paypal_payment_status'] = "charge";
		                $param['order_paypal_txn_id'] = "";
		                $param['order_paypal_ipn_track_id'] = "";
		                $param['order_payment_post'] = serialize("");
		                $param['order_payment_type'] = "Scholarship Program";
		                $this->save_order_with_payment($order_id,$param);
		                $url = l('cart/success')."?id=".$order_id."&token=".$this->order_no_encrypt($order_id);
		                redirect($url,1);
		                die();
					}
					//$data['total_order_amount'] = ($order_data['price']+$order_data['order_shipping_amount']+$order_data['order_tax_amount'])-$order_data['order_discount_amount'];

					// Payment Section Start
					// $data['item_name'] = 'Purchase Items';
					// $data['item_desc'] = $items;
					// $data['payment_url'] = PAYMENT_URL;
					// $data['merchant'] = MERCHANT;
					// $data['currency'] = CURRENCY;
					// $data['success_url'] = l('cart/success')."?id=".$order_data['order_id']."&token=".md5($order_data['order_id']);
					// $data['error_url'] = l('cart/error')."?id=".$order_data['order_id']."&token=".md5($order_data['order_id']);
					// Payment Section End

					// Paypal Payment Option Start
					$data['paypal_gateway_url'] = PAYPAL_GATEWAY_URL;
					$data['paypal_email'] = PAYPAL_BUSINESS_EMAIL;
					$data['success_url'] = l("payment/paypal/paypal_success")."?id=".$order_id."&code=".$this->order_no_encrypt($order_id);
					$data['notify_url'] = l("payment/paypal/paypal_notification")."?id=".$order_id."&code=".$this->order_no_encrypt($order_id);
					$data['cancel_url'] = l("payment/paypal/paypal_error")."?id=".$order_id."&code=".$this->order_no_encrypt($order_id);
					// Paypal Payment Option End

					$this->load_view('payment',$data);
				}
			}
		}
		else {
			redirect(l(''),true);
		}
	}

	private function is_checked_order($oid,$token)
	{
		$generate_code = $this->order_no_encrypt($oid);
		if($generate_code == $token) {
			$mode = true;
		}
		else {
			$mode = false;	
		}
		return $mode;
	}

	// WHEN PAYMENT AMOUNT RECEIVED
	public function success()
	{
		$mode = false;
		if((isset($_GET['id']) AND (intval($_GET['id']) > 0)) AND isset($_GET['token']))
		{

			$mode = $this->is_checked_order($this->input->get('id'),$this->input->get('token'));
		}

		if($mode) {

			// Banner
	        $data = array();
	        $data['banners'] = $this->layout_data['banners'];

			$this->layout_data['title'] = $data['title'] = "Payment Success";

			// if($this->userid > 0) {
			// 	$get_rewards_points = $this->model_rewards_config->get_order_rewards_points($this->total_order_amount);
				
			// 	$this->model_rewards_config->set_user_rewards($this->userid,$get_rewards_points);
			// }


			$this->cart->destroy();

			// $array_items = array(
			// 		'discount' => $this->session->userdata('discount'),
			// 		'shipping_charges' => $this->session->userdata('shipping_charges'),
			// 		);
			// $this->session->unset_userdata($array_items);
			$this->session->unset_userdata('discount');
			$this->session->unset_userdata('tax');
			$this->session->unset_userdata('shipping_charges');


			$this->load_view('success',$data);
		}
		else {
			redirect(l(''),true);
		}
	}

	// WHEN ISSUE FACE IN PAYMENT AMOUNT
	public function error()
	{
		$mode = false;
		if((isset($_GET['id']) AND (intval($_GET['id']) > 0)) AND isset($_GET['token']))
		{
			$mode = $this->is_checked_order($this->input->get('id'),$this->input->get('token'));
		}

		if($mode) {
			// Banner
	        $data = array();
	        $data['banners'] = $this->layout_data['banners'];

			$this->layout_data['title'] = $data['title'] = "Payment Error";

			$this->load_view('error',$data);
		}
		else {
			redirect(l(''),true);
		}
	}

	/**
		Delete Product in cart list
	*/
	public function ajax_remove()
	{
		$data['rowid'] = $this->input->post('rowid');
		$data['qty'] = 0;

		$this->cart->update($data);
		
		$json_param['status'] = true;
		$json_param['msg']['title'] = 'Remove Item';
		$json_param['msg']['desc'] = 'Remove Item in your basket';	

		echo json_encode($json_param);
	}


	/**
		Update Product in cart list
	*/
	public function ajax_update()
	{
		$qty = intval($_POST['qty']);

		if($qty > 0) {
			$product_id = $this->input->post('product_id');
			$data['rowid'] = $this->input->post('rowid');
			$data['qty'] = $qty;
			//$data['price'] = $this->_set_price($product_id,$qty);
			
			$this->cart->update($data);
			
			$json_param['status'] = true;
			$json_param['msg']['title'] = 'Update Item';
			$json_param['msg']['desc'] = 'Update Item in your basket';	
		}
		else {
			$json_param['status'] = false;
			$json_param['msg']['title'] = '';
			$json_param['msg']['desc'] = 'Please select qty';		
		}

		echo json_encode($json_param);
	}


	private function _save_user()
	{
		//if($this->isguest)
		if(1==1)
		{
			$data = array();
			$data['user_username'] = isset($_POST['user_username']) ? $_POST['user_username'] : '';
			$data['user_email'] = $_POST['shop_order']['order_billing_email'];
			$data['user_password'] = $this->model_user->_encrypt_password($_POST['password']);
			$data['user_firstname'] = $_POST['shop_order']['order_billing_fname'];
			$data['user_lastname'] = $_POST['shop_order']['order_billing_lname'];
			$data['user_type'] = CUSTOMER_USER;
			$data['user_status'] = 1;

			$this->model_user->set_attributes($data);
			$inserted_id = $this->model_user->save();

			// sent to user email
			$this->model_email->notification_register($inserted_id , 'user');
			// sent to admin email
			$this->model_email->notification_register($inserted_id , 'admin');

			//	SESSION DATA START
			$this->model_user->auto_login($inserted_id , 'front');
			//	SESSION DATA END
			
			return $inserted_id;
		}
	}


	/// SAVE ORDER 
	public function ajax_save_order()
	{

		if(isset($_POST) && array_filled($_POST))
		{
			//debug($_POST , 1);
			$_POST['shop_order']['order_payment_status'] = 0;

			if($this->validate("model_shop_order"))
			{
				$data = $_POST['shop_order'];

				if(isset($_POST['password']))
				{
					$ui = $this->model_user->check_unique_email();
					if($ui  == 0)
					{
						$user_id = $this->_save_user();
					}
					else
					{
						$user_id = $ui;
						$this->model_user->auto_login($user_id , 'front');
					}
				}
				else
				{
					$user_id = 	$this->userid;
				}


				if(isset($user_id) && intval($user_id) > 0)
				{
					$data['order_is_sandbox'] = (PAYMENT_MODE_IS_TEST) ? 1 : 0;
					$data['order_agreed_terms_status'] = 1;
					$data['order_delivery_status'] = 1;
					$data['order_status'] = 1;
					$data['order_shipping_amount'] = $this->shipping_charges;
					$data['order_shipping_data'] = serialize($this->session->userdata['shipping_charges']);
					$data['order_tax_amount'] = $this->tax;
					$data['order_discount_amount'] = $this->discount;
					$data['order_coupon'] = $this->coupon;
					$data['order_user_id'] = $user_id;
					$this->model_shop_order->set_attributes($data);
					$order_id = $this->model_shop_order->save();

					if($order_id > 0)
					{
						//save order item
						if(isset($this->cart_content) && array_filled($this->cart_content))
						{
							foreach($this->cart_content as $cart_content)
							{
								$param['item_order_id'] = $order_id;
								$param['item_product_id'] = $cart_content['id'];
								$param['item_product_name'] = $cart_content['name'];
								$param['item_product_img'] = $cart_content['options']['product_img'];
								$param['item_qty'] = $cart_content['qty'];
								$param['item_rate'] = $cart_content['price'];
								$param['item_price'] = $cart_content['subtotal'];
								$param['item_type'] = $cart_content['options']['type'];
								$param['item_serialize'] = serialize($cart_content);
								
								$this->model_shop_item->set_attributes($param);
								$inserted_id = $this->model_shop_item->save();
							}
						}// save order item
						
						$json_param['order']['status'] = true;
						$json_param['order']['msg']['title'] = 'Order save';
						$json_param['order']['msg']['desc'] = '';
						$json_param['order']['order_id'] = $order_id;
					}
				}
			}
			else
			{
				$json_param['order']['status'] = false;
				$json_param['order']['msg']['title'] = 'Error Occurred';
				$json_param['order']['msg']['desc'] = validation_errors();
			}
		}
		else
		{
			$json_param['order']['status'] = false;
			$json_param['order']['msg']['title'] = 'Error Occurred';
			$json_param['order']['msg']['desc'] = 'Error found please try again';
		}
		echo json_encode($json_param);
	}


	###### COUPON DISCOUNT START ######
	public function ajax_discount()
	{
		if(isset($_POST) && array_filled($_POST))
		{
			$coupon = htmlentities(trim($this->input->post('coupon')));
			$course_id = intval($this->input->post('course_id'));
			$data = $this->model_coupon->get_coupon_exist($coupon,$course_id);
			if(isset($data) && array_filled($data))
			{
				// $param = array();
		  //       $param['where']["order_user_id"] = $this->userid;
		  //       $user_order_count = $this->model_shop_order->find_count($param);     

				//if($user_order_count == 0)
				$today = date('Y-m-d');
				if(($today >= $data['coupon_start_date']) AND ($today <= $data['coupon_expire_date']))
				{
					$coupon_data = array();
					$coupon_data['coupon_id'] = $data['coupon_id'];

					$session_data = array();
					$session_data['discount']['coupon'] = $coupon_data;
					$session_data['discount']['coupon']['info'] = $data;
					$this->session->set_userdata($session_data);
					
				// 	Expire the coupon
				$coup_id = $data['coupon_id'];
				$coup_data['coupon_status'] = 0;
				$this->model_coupon->update_by_pk($coup_id,	$coup_data );
				
				//ends 

					$json_param['status'] = true;
					//$json_param['msg']['title'] = 'Error occurred';
					$json_param['msg']['desc'] = "Scholarship amount added in your order";
				}
				else
				{
					$json_param['status'] = false;
					$json_param['msg']['title'] = 'Error occurred';
					$json_param['msg']['desc'] = "Sorry, the coupon you are using is either expired or is invalid. Please try again.";
				}
			}
			else
			{
				$json_param['status'] = false;
				$json_param['msg']['title'] = 'Error occurred';
				$json_param['msg']['desc'] = "Sorry, we were not able to recognize the code you used. Please try again.";
			}
		}
		else
		{
			$json_param['status'] = false;
			$json_param['msg']['title'] = 'Error occurred';
			$json_param['msg']['desc'] = 'Error Found please try again';
		}

		echo json_encode($json_param);
	}
	###### COUPON DISCOUNT END ######


	public function redeem_points()
	{
		if($this->userid > 0)
		{
			$rewards = $this->model_rewards_config->get_total_rewards($this->userid);
			if($rewards > 0)
			{
				$rewards_amount = $this->model_rewards_config->convert_point_to_amount($rewards);
				
				$avail_points = $avail_amount = 0;

				$total_order_amount = $this->total_order_amount;
				// $total_order_amount = 5; // TEST CASE
				if($total_order_amount > $rewards_amount ){
					$avail_points = $rewards;
					$avail_amount = $rewards_amount;
				}
				else {
					$avail_points = $this->model_rewards_config->convert_amount_to_points($total_order_amount);
					$avail_amount = $total_order_amount;
				}
				
				$session_data = array();
				$session_data['rewards']['avail_points'] = $avail_points;
				$session_data['rewards']['avail_amount'] = $avail_amount;
				$this->session->set_userdata($session_data);

				$json_param['status'] = true;
				$json_param['desc'] = 'Points Redeems';
			}
			else {
				$json_param['status'] = false;
				$json_param['desc'] = '0 Point in your account';
			}
		}
		else {
			$json_param['status'] = false;
			$json_param['desc'] = 'Points available just for Registered users';
		}
		echo json_encode($json_param);
	}


	public function set_tax_amount()
	{
		$id = intval($this->input->post('id'));
		$data = $this->model_states->find_by_pk($id);
		
		$tax_amount = ($this->total_amount*$data['states_tax_total'])/100;

		$session_data = array();
		$session_data['tax']['tax_type'] = $data['states_rate_type'];
		$session_data['tax']['tax_total'] = $tax_amount;
		$session_data['tax']['data'] = serialize($data);
		$this->session->set_userdata($session_data);

		$json_param['status'] = true;
		$json_param['tax_label'] = "Add: Tax (".$data['states_rate_type'].")";
		$json_param['tax_amount'] = price($tax_amount);

		$this->tax = $this->_set_tax();
		$json_param['total_amount'] = price($this->get_order_amount());
		
		echo json_encode($json_param);
	}

	public function ajax_set_shipping_amount()
	{
		$json_param = array();
		$id = intval($this->input->post('id'));
		$country_id = intval($this->input->post('country_id'));

		if($id > 0) {
			$data = $this->postage_charges($id);

			$session_data = array();
			$type = 1;
			if($id == 5){
				if($country_id == 2) {
					$type = 2;
					$session_data['shipping_charges']['charges'] = 16.99;
				}
				else {
					$session_data['shipping_charges']['charges'] = 12.99;
				}
			}
			else {
				$session_data['shipping_charges']['charges'] = $data['charges'];
			}

			$session_data['shipping_charges']['info'] = $data;
			$session_data['shipping_charges']['info']['type'] = $type;
			$this->session->set_userdata($session_data);

			$json_param['status'] = true;
		
		}
		else {
			$json_param['status'] = false;
		}
		echo json_encode($json_param);
	}

	public function postage_charges($id=0)
	{
		$data = array();

		if($this->total_amount >= 30){
			$postage_1st = 0;
		}
		else {
			$postage_1st = ($this->total_amount >= 9.99) ? 1.49 : 1.99;	
		}

		$data[1] = array(
				'id'=>1,
				'name'=>"UK- Standard 1st class postage (Delivery usually within 2-3 days from postage)",
				'charges'=> $postage_1st ,
				); 


		$data[2] = array(
				'id'=>2,
				'name'=>"UK- 2nd class postage (Delivery usually within 3-5 working  days from postage)",
				'charges'=> ($this->total_amount >= 9.99) ? 0 : 0.99 ,
				);

		$data[3] = array(
				'id'=>3,
				'name'=>"UK- 1st Class Tracked & Signed- £4.49 (Delivery usually within 2-3 days from postage)",
				'charges'=> 4.49 ,
				);

		$data[4] = array(
				'id'=>4,
				'name'=>"UK- Next Day guarantee- £7.99 (Delivery usually within 1 day from postage)*",
				'charges'=> 7.99 ,
				);

		$data[5] = array(
				'id'=>5,
				'name'=>"Flat Rate (Europe £12.99, USA & Canada £16.99)",
				'charges'=> 12.99 ,
				);

		return isset($data[$id]) ? $data[$id] : $data;
	}
}
