<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	http://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = "home";

//admin
$route['admin'] = "admin";
$route['admin/(:any)'] = "admin/$1";


//frontend slugs
$route['dologin'] = "home/login";
$route['translate_uri_dashes'] = true;




// Static Pages
$route['about-us'] = "cms/about_us";
$route['terms-and-conditions'] = "cms/index/39";
$route['privacy-policy'] = "cms/index/37";
$route['faqs'] = "cms/faqs";
$route['country'] = "cms/country";
$route['contact-us'] = "contact_us";
$route['learning-resources'] = "cms/learning_resources";


// Acount Area
$route['dashboard'] = "account/dashboard";
$route['account-area'] = "account/dashboard";
$route['login'] = "registration/login";
$route['apply-now'] = "registration/apply_now";
//$route['signup'] = "registration";
$route['signup'] = "registration/login";
$route['forgot-password'] = "registration/forgot_password";
$route['ajax-save-signup'] = "signup/index";
$route['account-area/profile/edit'] = "account/profile/index";
$route['account-area/change-password'] = "account/profile/change_password";
$route['account-area/address-info'] = "account/profile/address_info";
$route['account-area/change-profile'] = "account/profile/about_us";
$route['account-area/my-order'] = "account/order";
$route['account-area/connected-account'] = "account/payment/connected_account";
$route['account-area/payment-subscription'] = "account/payment/subscriptions";

$route['account-area/my-courses'] = "account/my_courses/index";
//$route['account-area/my-courses/generate_test/(:any)'] = "account/my_courses/generate_test/$1";
$route['account-area/my-courses/generate_test/(:any)/(:any)'] = "account/my_courses/generate_test/$1/$2";
$route['account-area/my-courses/detail/(:any)'] = "account/my_courses/detail/$1";
$route['account-area/my-courses/quiz/(:any)'] = "account/my_courses/quiz/$1";
$route['account-area/my-courses/grade/(:any)'] = "account/my_courses/grade/$1";
$route['account-area/my-courses/submission/(:any)'] = "account/my_courses/submission/$1";
$route['account-area/my-courses/assignment/(:any)'] = "account/my_courses/assignment/$1";
$route['account-area/my-courses/assignment-detail/(:any)'] = "account/my_courses/assignment_detail/$1";
$route['account-area/my-courses/assignment-submit/(:any)'] = "account/my_courses/assignment_submit/$1";


$route['account-area/my-courses/test/(:any)'] = "account/my_courses/test/$1";
$route['account-area/my-courses/result/(:any)'] = "account/my_courses/result/$1";

// Ticket Management
// $route['account-area/inquiry-threading'] = "account/dashboard/inquiry_threading_listing";
// $route['account-area/inquiry-thread/(:any)'] = "account/dashboard/inquiry_threading_detail/$1";
// $route['account-area/my-ticket'] = "account/dashboard/inquiry_threading_listing";
//$route['signup-contributor'] = "registration/contributor_signup";
// $route['account-area/package-info'] = "account/profile/package_info";
// $route['account-area/favorite-article'] = "account/profile/favorite_article";



// Products
$route['shop'] = "shop/index/";
$route['shop/page'] = "shop/index/$1";
$route['shop/page/(:any)'] = "shop/index/$2";
$route['product-detail/(:any)'] = "shop/detail/$1";
//$route['service-detail/(:any)'] = "shop/service_detail/$1";

// Courses
$route['courses'] = "courses/index/";
$route['courses/page'] = "courses/index/$1";
$route['courses/page/(:any)'] = "courses/index/$2";
$route['course-detail/(:any)'] = "courses/detail/$1";



// Cart
$route['checkout'] = "cart/step_two";



// $route['service-detail/(:any)'] = "services/detail/$1";
// $route['event-detail/(:any)'] = "events/detail/$1";
// $route['rent-detail/(:any)'] = "rent/detail/$1";
// $route['blog-detail/(:any)'] = "blog/detail/$1";
// $route['classes-detail/(:any)'] = "classes/detail/$1";
// $route['products/(:any)'] = "products/index/$1";
// $route['products/rating'] = "products/rating";





