<?php







require 'vendor/autoload.php';







use net\authorize\api\contract\v1 as AnetAPI;



use net\authorize\api\controller as AnetController;







define("AUTHORIZENET_LOG_FILE", "phplog");



require_once "keys_config.php";







function chargeCreditCard($amount, $cardNumber, $expDate, $cardCode, $purchaseOrderNumber, $email, $firstName, $lastName, $gunName)



{



    /* Create a merchantAuthenticationType object with authentication details



       retrieved from the constants file */



    $merchantAuthentication = new AnetAPI\MerchantAuthenticationType();



    $merchantAuthentication->setName(API_LOGIN_ID);



    $merchantAuthentication->setTransactionKey(TRANSACTION_KEY);







    // Set the transaction's refId



    $refId = 'ref' . time();







    // Create the payment data for a credit card



    $creditCard = new AnetAPI\CreditCardType();



    $creditCard->setCardNumber($cardNumber);



    $creditCard->setExpirationDate($expDate);



    $creditCard->setCardCode($cardCode);







    // Add the payment data to a paymentType object



    $paymentOne = new AnetAPI\PaymentType();



    $paymentOne->setCreditCard($creditCard);







    // Create order information



    $order = new AnetAPI\OrderType();



    $order->setInvoiceNumber($purchaseOrderNumber);



    $order->setDescription($gunName);







    // Set the customer's Bill To address



    $customerAddress = new AnetAPI\CustomerAddressType();



    $customerAddress->setFirstName($firstName);



    $customerAddress->setLastName($lastName);



    // $customerAddress->setCompany("Souveniropolis");



    // $customerAddress->setAddress("14 Main Street");



    // $customerAddress->setCity("Pecan Springs");



    // $customerAddress->setState("TX");



    // $customerAddress->setZip("44628");



    // $customerAddress->setCountry("USA");







    // Set the customer's identifying information



    $customerData = new AnetAPI\CustomerDataType();



    $customerData->setType("individual");



    $customerData->setEmail($email);







    // // Add values for transaction settings



    // $duplicateWindowSetting = new AnetAPI\SettingType();



    // $duplicateWindowSetting->setSettingName("duplicateWindow");



    // $duplicateWindowSetting->setSettingValue("60");







    // Add some merchant defined fields. These fields won't be stored with the transaction,



    // but will be echoed back in the response.



    // $merchantDefinedField1 = new AnetAPI\UserFieldType();



    // $merchantDefinedField1->setName("customerLoyaltyNum");



    // $merchantDefinedField1->setValue("1128836273");







    $merchantDefinedField2 = new AnetAPI\UserFieldType();



    // $merchantDefinedField2->setName("favoriteColor");



    // $merchantDefinedField2->setValue("blue");







    // Create a TransactionRequestType object and add the previous objects to it



    $transactionRequestType = new AnetAPI\TransactionRequestType();



    $transactionRequestType->setTransactionType("authCaptureTransaction");



    $transactionRequestType->setAmount($amount);



    $transactionRequestType->setOrder($order);



    $transactionRequestType->setPayment($paymentOne);



    $transactionRequestType->setBillTo($customerAddress);



    $transactionRequestType->setCustomer($customerData);



    // $transactionRequestType->addToTransactionSettings($duplicateWindowSetting);



    // $transactionRequestType->addToUserFields($merchantDefinedField1);



    // $transactionRequestType->addToUserFields($merchantDefinedField2);







    // Assemble the complete transaction request



    $request = new AnetAPI\CreateTransactionRequest();



    $request->setMerchantAuthentication($merchantAuthentication);



    $request->setRefId($refId);



    $request->setTransactionRequest($transactionRequestType);







    // Create the controller and get the response



    $controller = new AnetController\CreateTransactionController($request);



    $response = $controller->executeWithApiResponse(\net\authorize\api\constants\ANetEnvironment::SANDBOX);  // SANDBOX OR PRODUCTION











    if ($response != null) {



        // Check to see if the API request was successfully received and acted upon



        if ($response->getMessages()->getResultCode() == "Ok") {



            // Since the API request was successful, look for a transaction response



            // and parse it to display the results of authorizing the card



            $tresponse = $response->getTransactionResponse();







            if ($tresponse != null && $tresponse->getMessages() != null) {



                return ["status" => true, "transaction_id" => $tresponse->getTransId(), "transaction_msg" => $tresponse->getMessages()[0]->getDescription()];



                // echo " Successfully created transaction with Transaction ID: " . $tresponse->getTransId() . "\n";



                // echo " Transaction Response Code: " . $tresponse->getResponseCode() . "\n";



                // echo " Message Code: " . $tresponse->getMessages()[0]->getCode() . "\n";



                // echo " Auth Code: " . $tresponse->getAuthCode() . "\n";



                // echo " Description: " . $tresponse->getMessages()[0]->getDescription() . "\n";



            } else {



                // echo "Transaction Failed \n";



                if ($tresponse->getErrors() != null) {



                    return ["status" => false, "error_code" => $tresponse->getErrors()[0]->getErrorCode(), "error_msg" => $tresponse->getErrors()[0]->getErrorText()];



                    // echo " Error Code  : " . $tresponse->getErrors()[0]->getErrorCode() . "\n";



                    // echo " Error Message : " . $tresponse->getErrors()[0]->getErrorText() . "\n";



                } else {



                    return ["status" => false, "error_code" => "", "error_msg" => "Transaction Failed"];
                }
            }



            // Or, print errors if the API request wasn't successful



        } else {



            // echo "Transaction Failed \n";



            $tresponse = $response->getTransactionResponse();







            if ($tresponse != null && $tresponse->getErrors() != null) {



                return ["status" => false, "error_code" => $tresponse->getErrors()[0]->getErrorCode(), "error_msg" => $tresponse->getErrors()[0]->getErrorText()];



                // echo " Error Code  : " . $tresponse->getErrors()[0]->getErrorCode() . "\n";



                // echo " Error Message : " . $tresponse->getErrors()[0]->getErrorText() . "\n";



            } else {



                return ["status" => false, "error_code" => $response->getMessages()->getMessage()[0]->getCode(), "error_msg" => $response->getMessages()->getMessage()[0]->getText()];



                // echo " Error Code  : " . $response->getMessages()->getMessage()[0]->getCode() . "\n";



                // echo " Error Message : " . $response->getMessages()->getMessage()[0]->getText() . "\n";



            }
        }
    } else {



        return ["status" => false, "error_code" => "", "error_msg" => "No response returned"];







        // echo  "No response returned \n";



    }







    // return $response;



}



function createSubscription($amount, $cardNumber, $expDate, $cardCode, $purchaseOrderNumber, $email, $firstName, $lastName, $subscription_name, $subscription_description, $total_days)

{

    /* Create a merchantAuthenticationType object with authentication details

       retrieved from the constants file */

    $merchantAuthentication = new AnetAPI\MerchantAuthenticationType();



    $merchantAuthentication->setName(API_LOGIN_ID);



    $merchantAuthentication->setTransactionKey(TRANSACTION_KEY);



    // Set the transaction's refId

    $refId = 'ref' . time();



    // Subscription Type Info

    $subscription = new AnetAPI\ARBSubscriptionType();

    $subscription->setName($subscription_name);



    $interval = new AnetAPI\PaymentScheduleType\IntervalAType();

    $interval->setLength($total_days);

    $interval->setUnit("days");



    $paymentSchedule = new AnetAPI\PaymentScheduleType();

    $paymentSchedule->setInterval($interval);

    $paymentSchedule->setStartDate(new DateTime(date('Y-m-d'))); // format YEAR-month-day 2035-12-30

    $paymentSchedule->setTotalOccurrences("12");

    // $paymentSchedule->setTrialOccurrences("1");



    $subscription->setPaymentSchedule($paymentSchedule);

    $subscription->setAmount($amount);

    // $subscription->setTrialAmount("0.00");



    $creditCard = new AnetAPI\CreditCardType();

    $creditCard->setCardNumber($cardNumber);

    $creditCard->setExpirationDate($expDate);

    $creditCard->setCardCode($cardCode);



    $payment = new AnetAPI\PaymentType();

    $payment->setCreditCard($creditCard);

    $subscription->setPayment($payment);



    $order = new AnetAPI\OrderType();

    $order->setInvoiceNumber($purchaseOrderNumber);

    $order->setDescription($subscription_description);

    $subscription->setOrder($order);



    $billTo = new AnetAPI\NameAndAddressType();

    $billTo->setFirstName($firstName);

    $billTo->setLastName($lastName);



    $subscription->setBillTo($billTo);



    $request = new AnetAPI\ARBCreateSubscriptionRequest();

    $request->setmerchantAuthentication($merchantAuthentication);

    $request->setRefId($refId);

    $request->setSubscription($subscription);

    $controller = new AnetController\ARBCreateSubscriptionController($request);



    $response = $controller->executeWithApiResponse(\net\authorize\api\constants\ANetEnvironment::SANDBOX);



    if (($response != null) && ($response->getMessages()->getResultCode() == "Ok")) {

        // echo "SUCCESS: Subscription ID : " . $response->getSubscriptionId() . "\n";

        return ["status" => true, "subscription_id" => $response->getSubscriptionId(), "subscription_msg" => $response->getMessages()[0]->getDescription()];
    } else {



        return ["status" => false, "error_code" => $response->getMessages()->getMessage()[0]->getCode(), "error_msg" => $response->getMessages()->getMessage()[0]->getText()];



        // echo "ERROR :  Invalid response\n";

        // $errorMessages = $response->getMessages()->getMessage();

        // echo "Response : " . $errorMessages[0]->getCode() . "  " .$errorMessages[0]->getText() . "\n";

    }



    // return $response;

}



function cancelSubscription($subscriptionId)

{

    /* Create a merchantAuthenticationType object with authentication details

       retrieved from the constants file */

    $merchantAuthentication = new AnetAPI\MerchantAuthenticationType();



    $merchantAuthentication->setName(API_LOGIN_ID);



    $merchantAuthentication->setTransactionKey(TRANSACTION_KEY);



    // Set the transaction's refId

    $refId = 'ref' . time();



    $request = new AnetAPI\ARBCancelSubscriptionRequest();

    $request->setMerchantAuthentication($merchantAuthentication);

    $request->setRefId($refId);

    $request->setSubscriptionId($subscriptionId);



    $controller = new AnetController\ARBCancelSubscriptionController($request);



    $response = $controller->executeWithApiResponse(\net\authorize\api\constants\ANetEnvironment::SANDBOX);



    if (($response != null) && ($response->getMessages()->getResultCode() == "Ok")) {

        // $successMessages = $response->getMessages()->getMessage();

        // echo "SUCCESS : " . $successMessages[0]->getCode() . "  " .$successMessages[0]->getText() . "\n";

        return ["status" => true, "subscription_msg" => $response->getMessages()[0]->getText()];
    } else {

        return ["status" => false, "error_code" => $response->getMessages()->getMessage()[0]->getCode(), "error_msg" => $response->getMessages()->getMessage()[0]->getText()];



        // echo "ERROR :  Invalid response\n";

        // $errorMessages = $response->getMessages()->getMessage();

        // echo "Response : " . $errorMessages[0]->getCode() . "  " .$errorMessages[0]->getText() . "\n";



    }



    // return $response;



}



function getSubscription($subscriptionId)

{

    /* Create a merchantAuthenticationType object with authentication details

       retrieved from the constants file */

    $merchantAuthentication = new AnetAPI\MerchantAuthenticationType();



    $merchantAuthentication->setName(API_LOGIN_ID);



    $merchantAuthentication->setTransactionKey(TRANSACTION_KEY);



    // Set the transaction's refId

    $refId = 'ref' . time();



    // Creating the API Request with required parameters

    $request = new AnetAPI\ARBGetSubscriptionRequest();

    $request->setMerchantAuthentication($merchantAuthentication);

    $request->setRefId($refId);

    $request->setSubscriptionId($subscriptionId);

    $request->setIncludeTransactions(true);



    // Controller

    $controller = new AnetController\ARBGetSubscriptionController($request);



    // Getting the response

    $response = $controller->executeWithApiResponse(\net\authorize\api\constants\ANetEnvironment::SANDBOX);



    if (($response != null) && ($response->getMessages()->getResultCode() == "Ok")) {

        return ["status" => true];
    } else {

        return ["status" => false, "error_code" => $response->getMessages()->getMessage()[0]->getCode(), "error_msg" => $response->getMessages()->getMessage()[0]->getText()];
    }
}
